import {StyleSheet} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  overlay: {
    flex: 1,
    backgroundColor: R.colors.blackShadow,
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContainer: {
    backgroundColor: 'white',
    borderRadius: 15,
    maxHeight: '70%',
    paddingVertical: 20,
    marginHorizontal: 15,
  },
  header: {
    alignItems: 'center',
    marginHorizontal: 20,
  },
  headerTitle: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.blue,
  },
  formContainer: {
    paddingHorizontal: 20,
  },
  fieldContainer: {
    marginBottom: 20,
  },
  containerDropDown: {
    marginBottom: 10,
  },
  imageIcon: {
    width: 15,
    height: 15,
  },
  label: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  required: {
    color: 'red',
  },
  textInput: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    paddingHorizontal: 10,
    paddingVertical: 5,
  },
  textArea: {
    height: 80,
    textAlignVertical: 'top',
  },
  flatListSelect: {
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  textChip: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
  text_2: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  pickerContainer: {
    borderWidth: 1,
    borderColor: '#ddd',
    borderRadius: 8,
    backgroundColor: 'white',
  },
  datePickerContainer: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
    borderWidth: 1,
    borderColor: '#ddd',
    borderRadius: 8,
    paddingHorizontal: 12,
    paddingVertical: 12,
    backgroundColor: 'white',
  },
  datePickerText: {
    fontSize: 14,
    color: '#666',
  },
  containerIcon: {
    marginRight: 2,
  },
  fileUploadContainer: {
    borderWidth: 2,
    borderColor: '#ddd',
    borderStyle: 'dashed',
    borderRadius: 8,
    paddingVertical: 30,
    alignItems: 'center',
    backgroundColor: '#f9f9f9',
  },
  fileUploadText: {
    marginTop: 8,
    fontSize: 14,
    color: R.colors.blue,
    fontWeight: '500',
  },
  buttonContainer: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
    paddingTop: 20,
    gap: 10,
  },
  cancelButton: {
    flex: 1,
    justifyContent: 'center',
    backgroundColor: R.colors.orange,
    alignItems: 'center',
  },
  cancelButtonText: {
    fontSize: 16,
    color: '#666',
    fontWeight: '500',
  },
  saveButton: {
    flex: 1,
    paddingVertical: 12,
    borderRadius: 8,
    backgroundColor: R.colors.blue,
    alignItems: 'center',
  },
  saveButtonText: {
    fontSize: 16,
    color: 'white',
    fontWeight: '500',
  },
  chip: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingLeft: 10,
    paddingRight: 10,
    height: 25,
    borderRadius: 10,
    marginBottom: 10,
    marginRight: 5,
    backgroundColor: R.colors.blue2,
    alignSelf: 'flex-start',
  },
});
export default styles;
