import React, {useState} from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  FlatList,
  ScrollView,
  LogBox,
} from 'react-native';
import styles from './style';
import FAB from '../../../components/FAB/fab';
import SubButton from '../../../components/FAB/sub_button';
import R from '../../../assets/R';
import Header from '../../../components/Header/Header';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import WorkReportModal from './detail/modal_add_report';
import EditReportModal from './detail/modal_edit_report';
const DetailListWorkDeliverToMeView = props => {
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const {data, dataList, dataReport} = props;
  const [showWorkReportModal, setShowWorkReportModal] = useState(false);
  const [showEditReportModal, setShowEditReportModal] = useState(false);
  const getColor = status => {
    switch (status) {
      case 'Chờ duyệt':
        return R.colors.blue;
      case 'Hoàn thành':
        return R.colors.green;
      case 'Cần chỉnh sửa':
        return R.colors.orange;
      case 'Đang thực hiện':
        return R.colors.orange;
      case 'Chờ báo cáo':
        return R.colors.blue;
      default:
        return R.colors.gray;
    }
  };

  const renderItem = ({item}) => {
    return (
      <View style={styles.containerCard}>
        <View style={{flexDirection: 'row', marginBottom: 3}}>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.title} -{' '}
          </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.time}{' '}
          </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>{item.date}</Text>
        </View>
        <View
          style={{
            borderWidth: 1,
            borderColor: R.colors.grayBorderInputTextHeader,
            padding: 10,
            borderRadius: 10,
            marginBottom: 5,
          }}>
          <Text style={[styles.text, {color: R.colors.gray4}]}>
            {item.content}
          </Text>
        </View>
        <TouchableOpacity
          style={{
            flexDirection: 'row',
            backgroundColor: R.colors.blue1,
            height: 30,
            alignItems: 'center',
            paddingHorizontal: 10,
            borderRadius: 10,
            marginBottom: 10,
            justifyContent: 'space-between',
          }}>
          <Text style={[styles.text, {color: R.colors.black, fontSize: 10}]}>
            {item.fileTitle}
          </Text>
          <Image source={R.images.icDownload} style={styles.image} />
        </TouchableOpacity>
        <Text style={[styles.text, {color: R.colors.blue}]}>
          Phản hồi báo cáo
        </Text>
        <FlatList
          data={item.responder || []}
          renderItem={renderItem_2}
          showsVerticalScrollIndicator={false}
          vertical
          style={{marginLeft: 15}}
          keyExtractor={(item, index) => `${index}`}
        />
      </View>
    );
  };

  const renderItem_2 = ({item}) => {
    return (
      <View style={styles.containerCard}>
        <View style={{flexDirection: 'row', marginBottom: 3}}>
          <Text style={[styles.text, {color: R.colors.black}]}>
            {item.name} - {item.code}{' '}
          </Text>
          <Text style={[styles.text, {color: R.colors.black}]}>
            {item.time} {item.date}
          </Text>
        </View>
        <View
          style={{
            borderWidth: 1,
            borderColor: R.colors.grayBorderInputTextHeader,
            padding: 10,
            borderRadius: 10,
          }}>
          <Text style={[styles.text, {color: R.colors.gray4}]}>
            {item.content}
          </Text>
        </View>
      </View>
    );
  };

  const renderView = () => {
    return (
      <View style={styles.body}>
        <Text
          style={[
            styles.text,
            {fontSize: R.fontsize.fontSizeSubTitle, marginBottom: 5},
          ]}>
          {data.title}
        </Text>
        <View style={{flexDirection: 'row', justifyContent: 'space-between'}}>
          <Text style={[styles.text, {marginBottom: 5}]}>
            Thời hạn: <Text style={styles.sub_text}>{data.deadline}</Text>
          </Text>
          <Text style={[styles.text, {marginBottom: 5}]}>
            Trạng thái:{' '}
            <Text style={{color: getColor(data.status)}}>{data.status}</Text>
          </Text>
        </View>
        <Text style={[styles.text, {marginBottom: 5}]}>
          Công việc thuộc văn bản:
          <Text style={[styles.sub_text, {color: R.colors.blue}]}>
            {data.document}
          </Text>
        </Text>
        <Text style={[styles.text, {marginBottom: 5}]}>
          Người giám sát:
          <Text style={styles.sub_text}>
            {data.supervisor.map(item => item.name).join(', ')}
          </Text>
        </Text>
        <Text style={[styles.text, {marginBottom: 5}]}>
          Người thực hiện:
          <Text style={styles.sub_text}>
            {data.implementer.map(item => item.name).join(', ')}
          </Text>
        </Text>
        <Text style={styles.text}>Nội dung công việc:</Text>
        <View style={styles.containerContent}>
          <Text style={[styles.text, {color: R.colors.gray4}]}>
            {data.content}
          </Text>
        </View>
        <Text style={styles.text}>Tài liệu đính kèm</Text>
        <TouchableOpacity style={styles.containerFile}>
          <Text style={[styles.text, {fontSize: R.sizes.xs}]}>
            Quyết định thông báo đào tạo - QD347583
          </Text>
          <Image source={R.images.icDownload} style={styles.image} />
        </TouchableOpacity>

        <View style={styles.containerDropdown}>
          <Text
            style={[
              styles.text,
              {
                marginBottom: 3,
                fontSize: R.fontsize.fontSizeLabel,
                fontFamily: R.fonts.fontMedium,
                fontWeight: '600',
                color: R.colors.black,
              },
            ]}>
            Thẻ
          </Text>
          <Dropdown
            height={35}
            // items={items}
            placeholder="Chọn tùy chọn"
            onSelect={item => console.log('Bạn đã chọn:', item)}
          />
        </View>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Danh sách thẻ đã chọn :
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150, marginBottom: 5}}
          showsVerticalScrollIndicator={false}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />
        <Text style={[styles.text, {marginBottom: 3}]}>
          Báo cáo công việc :
        </Text>
        <FlatList
          data={dataReport || []}
          renderItem={renderItem}
          showsVerticalScrollIndicator={false}
          vertical
          keyExtractor={(item, index) => `${index}`}
        />
      </View>
    );
  };

  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity style={styles.containerIcon} onPress={onPress}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };

  const handleReportPress = () => {
    if (data.status === 'Chờ báo cáo') {
      setShowWorkReportModal(true);
    } else if (data.status === 'Chờ duyệt') {
      setShowEditReportModal(true);
    } else if (data.status === 'Cần chỉnh sửa') {
      setShowWorkReportModal(true);
    } else if (data.status === 'Đang thực hiện') {
      setShowWorkReportModal(true);
    }
  };

  const handleWorkReportSubmit = reportContent => {
    console.log('Work report submitted:', reportContent);
  };

  const handleEditReportSubmit = reportContent => {
    console.log('Edit report submitted:', reportContent);
  };

  const shouldShowFAB = () => {
    return data.status !== 'Hoàn thành';
  };

  return (
    <View style={styles.container}>
      <Header title={'Chi tiết công việc'} isBack />
      <ScrollView showsVerticalScrollIndicator={false}>
        {renderView(data)}
      </ScrollView>
      {shouldShowFAB() && (
        <FAB>
          <SubButton
            onPress={handleReportPress}
            label={data.status === 'Chờ duyệt' ? 'Sửa báo cáo' : 'Báo cáo'}
            images={R.images.icEdit}
            backgroundColor={R.colors.orange}
          />
        </FAB>
      )}

      <WorkReportModal
        visible={showWorkReportModal}
        onClose={() => setShowWorkReportModal(false)}
        onSubmit={handleWorkReportSubmit}
      />

      <EditReportModal
        visible={showEditReportModal}
        onClose={() => setShowEditReportModal(false)}
        onSubmit={handleEditReportSubmit}
        initialContent=""
      />
    </View>
  );
};

export default DetailListWorkDeliverToMeView;
