import {StyleSheet} from 'react-native';
import R from '../../../../../assets/R';

const styles = StyleSheet.create({
  overlay: {
    flex: 1,
    backgroundColor: R.colors.blackShadow,
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContainer: {
    backgroundColor: 'white',
    borderRadius: 12,
    padding: 20,
    width: '90%',
    maxWidth: 400,
  },
  title: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontWeight: '600',
    color: R.colors.blue,
    textAlign: 'center',
  },
  required: {
    color: R.colors.red,
    fontSize: 14,
    fontWeight: '500',
  },
  label: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  textInput: {
    borderWidth: 1,
    borderColor: R.colors.gray,
    borderRadius: 8,
    padding: 12,
    fontSize: 14,
    color: R.colors.black,
    marginBottom: 16,
    minHeight: 120,
  },
  attachmentContainer: {
    borderWidth: 1,
    borderColor: R.colors.blue,
    borderRadius: 8,
    padding: 20,
    alignItems: 'center',
    marginBottom: 20,
  },
  uploadIcon: {
    width: 23,
    height: 28,
    tintColor: R.colors.blue,
    marginBottom: 5,
  },
  attachmentText: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.blue,
    fontWeight: '500',
  },
  buttonContainer: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
  },
  cancelButton: {
    flex: 1,
    backgroundColor: R.colors.orange,
    borderRadius: 8,
    paddingVertical: 12,
    alignItems: 'center',
  },
  submitButton: {
    flex: 1,
    backgroundColor: R.colors.blue,
    borderRadius: 8,
    paddingVertical: 12,
    alignItems: 'center',
  },
  disabledButton: {
    backgroundColor: R.colors.gray,
  },
  cancelButtonText: {
    color: 'white',
    fontSize: 16,
    fontWeight: '600',
  },
  submitButtonText: {
    color: 'white',
    fontSize: 16,
    fontWeight: '600',
  },
});

export default styles;
