import React, {useState} from 'react';
import WorkReportModalView from './view';

const WorkReportModal = ({visible, onClose, onSubmit}) => {
  const [reportContent, setReportContent] = useState('');

  const handleSubmit = () => {
    if (reportContent.trim()) {
      onSubmit(reportContent);
      setReportContent('');
      onClose();
    }
  };

  const handleCancel = () => {
    setReportContent('');
    onClose();
  };

  const handleContentChange = (content) => {
    setReportContent(content);
  };

  const handleAddAttachment = () => {
  };

  return (
    <WorkReportModalView
      visible={visible}
      onClose={onClose}
      reportContent={reportContent}
      onContentChange={handleContentChange}
      onSubmit={handleSubmit}
      onCancel={handleCancel}
      onAddAttachment={handleAddAttachment}
    />
  );
};

export default WorkReportModal;
