import {StyleSheet, Text, View} from 'react-native';
import R from '../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  card: {
    borderRadius: 10,
    padding: 5,
    marginVertical:10,
    marginHorizontal: 15,
    alignItems: 'center',
    justifyContent: 'center',

    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  btnCard: {
    borderRadius: 10,
    borderWidth: 1,
    padding: 5,
    width: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  text: {
    fontSize: R.sizes.sm,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  containerCard: {
    padding: 10,
    borderRadius: 10,
    marginVertical: 7.5,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 1,
    elevation: Platform.OS === 'ios' ? 1 : 2,
    marginHorizontal: 15,
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
  },
  containerText: {
    alignItems: 'center',
    justifyContent: 'center',
  },
  btnRight: {},
  containerEmpty: {
    alignItems: 'center',
    justifyContent: 'center',
  },
  textEmpty: {
    color: R.colors.red,
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
  }
});

export default styles;
