import React, {useState} from 'react';
import {
  Image,
  Platform,
  SafeAreaView,
  StatusBar,
  StyleSheet,
  Text,
  TouchableOpacity,
  View,
} from 'react-native';
import R from '../../assets/R';
import {
  getWidth,
  HEIGHTXD,
  WIDTHXD,
  WIDTHXDICON,
  HEIGHT,
  getFontSize,
  WIDTH,
} from '../../config/Functions';
import {useNavigation} from '@react-navigation/native';
const Header = ({
  title, 
  isBack
}) => {
  const navigate = useNavigation();
  return (
    <SafeAreaView style={styles.safeArea}>
      <StatusBar 
        barStyle="light-content"
        translucent={false}
        backgroundColor='black'
      />
    <View style={styles.headerContainer}>
      <Text numberOfLines={1} style={styles.txtTitle}>
        {title}
      </Text>
      {isBack && (
        <TouchableOpacity
          style={styles.btnBack}
          onPress={() => navigate.goBack()}>
            <Image source={R.images.icBack} style={{width: 20, height: 15}} />
        </TouchableOpacity>
      )}
    </View>
    </SafeAreaView>
  );
};

export default Header;

const styles = StyleSheet.create({
  safeArea:{
    backgroundColor:R.colors.blue,
  },
  headerContainer: {
    height: HEIGHT(45),
    width: '100%',
    flexDirection: 'row',
    alignItems: 'center',
    marginBottom: 2,
    justifyContent: 'center',
    backgroundColor: R.colors.blue, 
  },

  txtTitle: {
    flex: 1,
    fontSize: getFontSize(16),
    textAlign: 'center',
    fontWeight: 'bold',
    color: R.colors.white,
  },
  btnBack: {
    position: 'absolute',
    left: 10,
    width: WIDTH(35),
    height: HEIGHT(30),
    alignItems: 'center',
    justifyContent: 'center',
  },
});
