import {StyleSheet, Text, View, Platform} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  text: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  card: {
    borderRadius: 10,
    marginVertical: 10,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
    marginHorizontal: 15,
  },
  // Styles cho status header
  statusHeaderContainer: {
    backgroundColor: R.colors.white,
    borderTopRightRadius: 10,
    borderTopLeftRadius: 10,
  },
  statusHeader: {
    borderTopRightRadius: 10,
    borderTopLeftRadius: 10,
  },
  statusText: {
    fontSize: R.sizes.sm,
    paddingHorizontal: 10,
    paddingVertical: 2,
    color: R.colors.white,
    fontWeight: 'bold',
    fontFamily: R.fonts.fontMedium,
  },
  statusTextInner: {
    fontSize: R.sizes.sm,
    color: R.colors.white,
  },
  // Styles cho card content
  cardContent: {
    paddingHorizontal: 10,
    paddingTop: 3,
    paddingBottom: 10,
  },
  row: {
    flexDirection: 'row',
  },
  rowFlex: {
    flex: 1,
  },
  labelText: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  valueText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  // Styles cho button container
  buttonContainer: {
    alignItems: 'flex-end',
  },
  // Styles cho summary section
  summaryContainer: {
    alignItems: 'center',
    marginTop: 10,
  },
  summaryTitle: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  summaryValue: {
    fontSize: 11,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
  },
});

export default styles;
