import React, { useState } from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  ScrollView,
  Image,
  LogBox,
} from 'react-native';
import Header from '../../../components/Header/Header';
import styles from './style';
import TextField from '../../../components/Input/TextField';
import R from '../../../assets/R';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import TextMulti from '../../../components/Input/TextMulti';
import Button from '../../../components/Button';

const RegisterAbsenceView = props => {
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const {
    semester,
    academicYear,
    teacherCode,
    reason,
    selectedClass,
    selectedSchedule,
    selectedSubstituteTeacher,
    selectedDocument,
    setSelectedClass,
    setSelectedSchedule,
    setSelectedSubstituteTeacher,
    setReason,
    setTeacherCode,
    setSemester,
    setAcademicYear,  
    onSubmit,
    onDocumentPicker,
  } = props;

 
  return (
    <View style={styles.container}>
      <Header title={'Đăng ký báo nghỉ'} isBack />
      <ScrollView showsVerticalScrollIndicator={false} style={styles.body}>
        <View style={styles.marginBottom35}>
          <View style={styles.containerInput}>
            <View style={styles.flexOne}>
              <TextField
                title={'Học kỳ'}
                required
                value={semester}
                onChangeText={setSemester}
                backgroundColor={R.colors.gray}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                placeholder="Nhập học kỳ"
                editable={false}
              />
            </View>
            <View style={styles.flexSpacer}></View>
            <View style={styles.flexOne}>
              <TextField
                title={'Năm học'}
                required
                value={academicYear}
                onChangeText={setAcademicYear}
                backgroundColor={R.colors.gray}
                color={R.colors.black}
                fontSize={R.sizes.sm}
                fontSizeTitle={R.sizes.sm}
                containerBackgroundColor={R.colors.white}
                placeholder="Nhập năm học"
                editable={false}
              />
            </View>
          </View>
          <TextField
            title={'Mã CBGV'}
            required
            value={teacherCode}
            onChangeText={setTeacherCode}
            backgroundColor={R.colors.gray}
            color={R.colors.black}
            fontSize={R.sizes.sm}
            fontSizeTitle={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
            placeholder="Nhập mã CBGV"
            editable={false}
          />
          <View style={styles.containerDropDown}>
            <View style={styles.rowLayout}>
              <Text style={[styles.txtSubtitle, styles.titleText]}>
                Mã lớp{' '}
              </Text>
              <Text style={styles.requiredText}>*</Text>
            </View>
            <Dropdown 
              title={'Mã lớp'} 
              selectedValue={selectedClass}
              onValueChange={setSelectedClass}
            />
          </View>
          <View style={styles.containerDropDown}>
            <View style={styles.rowLayout}>
              <Text style={[styles.txtSubtitle, styles.titleText]}>
                Lịch báo nghỉ{' '}
              </Text>
              <Text style={styles.requiredText}>*</Text>
            </View>
            <Dropdown 
              title={'Lịch báo nghỉ'} 
              selectedValue={selectedSchedule}
              onValueChange={setSelectedSchedule}
            />
          </View>

          <TextMulti
            title={'Lý do nghỉ'}
            required
            value={reason}
            onChangeText={setReason}
            color={R.colors.black}
            fontSize={R.sizes.sm}
            titleFontSize={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
            containerMarginTop={15}
            placeholder="Nhập lý do nghỉ"
          />
          <View style={styles.containerDropDown}>
            <View style={styles.rowLayout}>
              <Text style={[styles.txtSubtitle, styles.titleText]}>
                Giảng viên thay thế
              </Text>
              <Text style={styles.requiredText}>*</Text>
            </View>
            <Dropdown 
              title={'Giảng viên thay thế'} 
              selectedValue={selectedSubstituteTeacher}
              onValueChange={setSelectedSubstituteTeacher}
            />
          </View>

          <View style={styles.marginTop15}>
            <Text style={[styles.txtSubtitle, styles.titleText]}>
              Minh chứng
            </Text>
            <TouchableOpacity 
              style={styles.cardDocument}
              onPress={() => {
                // TODO: Implement document picker
                console.log('Open document picker');
              }}
            >
              <Image
                source={R.images.icDocument}
                style={{width: 30, height: 30}}
                resizeMode="contain"
              />
              <Text style={[styles.txtSubtitle, styles.documentText]}>
                {selectedDocument ? selectedDocument.name : 'Thêm tài liệu'}
              </Text>
            </TouchableOpacity>
          </View>

          <Button
            title={'Đăng ký'}
            textColor={R.colors.white}
            onPress={onSubmit}
            backgroundColor={R.colors.blue}
            fontSize={R.sizes.sm}
            fontFamily={R.fonts.fontMedium}
            height={35}
            containerStyle={{marginTop: 15, borderRadius: 10}}
          />
        </View>
      </ScrollView>
    </View>
  );
};

export default RegisterAbsenceView;
