import React, {Component, useMemo, useState} from 'react';
import {View, Text, Linking} from 'react-native';
import * as SCREENNAME from '../../routers/ScreenNames';
import Homeview from './view';
import R from '../../assets/R';
import {useNavigation} from '@react-navigation/native';
const Home = props => {
  const navigation = useNavigation();
  const [selectedMenuItem, setSelectedMenuItem] = useState('');
  const [searchText, setSearchText] = useState('');
  const [userProfile, setUserProfile] = useState({
    name: 'NGUYỄN MINH ĐỨC',
    phone: '0895457',
    avatar: null,
  });
  const menuTeachingActivities = [
    {
      id: 1,
      title: 'Lịch dạy, coi thi',
      icon: R.images.icLichDay,
      screenName: SCREENNAME.DRAWERTABSCHEDULE,
      action: 'NAVIGATE',
    },
    {
      id: 2,
      title: 'Báo nghỉ',
      icon: R.images.icBaoNghi,
      screenName: SCREENNAME.LISTRESTREPORT,
      action: 'NAVIGATE',
    },
    {
      id: 3,
      title: 'Báo bù',
      icon: R.images.icBaoBu,
      screenName: SCREENNAME.LISTMAKEUPCLASSES,
      action: 'NAVIGATE',
    },
    {
      id: 4,
      title: 'Xác nhận dạy thay',
      icon: R.images.icXacNhanDayThay,
      screenName: SCREENNAME.SUBTEACHER,
      action: 'NAVIGATE',
    },
    {
      id: 5,
      title: 'Điểm danh',
      icon: R.images.icDiemDanh,
      screenName: SCREENNAME.LISTROLLCALL,
      action: 'NAVIGATE',
    },
    {
      id: 6,
      title: 'Cố vấn học tập',
      icon: R.images.icCoVanHT,
      screenName: SCREENNAME.LISTACADEMICADVISOR,
      action: 'NAVIGATE',
    },
  ];
  const menuStatistics = [
    {
      id: 7,
      title: 'Thống kê giảng dạy',
      icon: R.images.icThongKe,
      screenName: SCREENNAME.STATISTICS,
      action: 'NAVIGATE',
    },
    {
      id: 8,
      title: 'Khảo sát sự kiện',
      icon: R.images.icKhaoSatSuKien,
      screenName: SCREENNAME.HOMESCREEN,
      action: 'NAVIGATE',
    },
    {
      id: 9,
      title: 'Kết quả đánh giá',
      icon: R.images.icKetQuaDanhGia,
      screenName: SCREENNAME.LISTFEEDBACK,
      action: 'NAVIGATE',
    },
  ];
  const menuNotification = [
    {
      id: 10,
      title: 'Văn bản đến',
      icon: R.images.icVanBanDen,
      screenName: SCREENNAME.INCOMINGDOCUMENT,
      action: 'NAVIGATE',
    },
    {
      id: 11,
      title: 'Văn bản đi',
      icon: R.images.icVanBanDi,
      screenName: SCREENNAME.LISTSENDDOCUMENT,
      action: 'NAVIGATE',
    },
    {
      id: 12,
      title: 'Công việc',
      icon: R.images.icCongViec,
      screenName: SCREENNAME.LISTWORK,
      action: 'NAVIGATE',
    },
    {
      id: 13,
      title: 'Mail',
      icon: R.images.icDChiThu,
      screenName: SCREENNAME.EMAIL,
      action: 'NAVIGATE',
    },
  ];

  //Hàm tìm kiếm trong local theo tiêu đề chỉ hoạt động khi thực hiện tìm kiếm (searchText) thay đổi
  const [filterActivity, filterStatics, filterNotification] = useMemo(() => {
    if (!searchText.trim())
      return [menuTeachingActivities, menuStatistics, menuNotification];

    const toLowerCaseSearchText = searchText.toLowerCase();

    const filterByTitle = list =>
      list.filter(item =>
        item.title.toLowerCase().includes(toLowerCaseSearchText),
      );

    return [
      filterByTitle(menuTeachingActivities),
      filterByTitle(menuStatistics),
      filterByTitle(menuNotification),
    ];
  }, [searchText]);

  const actionHandlers = {
    NAVIGATE: item => {
      navigation.navigate(item.screenName, {
        ...item.params,
        itemData: item,
        title: item.title,
      });
    },

    OPEN_URL: item => {
      Linking.openURL(item.url).catch(err => {
        console.error('Failed to open URL:', err);
      });
    },

    SHOW_MODAL: item => {
      console.log('Show modal for:', item.title);
    },

    CALL_API: item => {
      console.log('Calling API for:', item.title);
    },
  };

  const handleMenuItemPress = item => {
    const handler = actionHandlers[item.action];
    if (handler) {
      handler(item);
    } else {
      console.warn(`No handler found for action: ${item.action}`);
    }
  };

  const handleSearchChange = text => {
    setSearchText(text);
  };

  return (
    <Homeview
      menuActivity={filterActivity}
      menuStatistics={filterStatics}
      menuNotification={filterNotification}
      selectedMenuItem={selectedMenuItem}
      searchText={searchText}
      userProfile={userProfile}
      onMenuItemPress={handleMenuItemPress}
      onSearchChange={handleSearchChange}
    />
  );
};

export default Home;
