import {StyleSheet} from 'react-native';
import R from '../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  loadingContainer: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.white,
  },
  loadingText: {
    marginTop: 10,
    fontSize: R.fontsize.fontSizeSubTitle,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.gray2,
  },
  listContainer: {},
  dateSection: {
    marginBottom: 10,
  },
  dateSectionHeader: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.gray2,
    paddingHorizontal: 15,
    paddingVertical: 10,
  },
  emailItem: {
    flexDirection: 'row',
    paddingHorizontal: 15,
    paddingVertical: 10,
    backgroundColor: R.colors.white,
    alignItems: 'flex-start',
  },
  unreadEmail: {},
  avatarContainer: {
    marginRight: 10,
    marginTop: 5,
  },
  avatar: {
    width: 40,
    height: 40,
    borderRadius: 20,
    backgroundColor: R.colors.blue,
    justifyContent: 'center',
    alignItems: 'center',
  },
  avatarText: {
    color: R.colors.white,
    fontSize: 16,
    fontWeight: 'bold',
  },
  emailContent: {
    flex: 1,
    marginRight: 10,
  },
  emailHeader: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  senderName: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.gray4,
    flex: 1,
    marginRight: 10,
  },
  unreadText: {
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  unreadEmail: {
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.gray3,
  },
  emailDate: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.gray2,
  },
  emailSubject: {
    fontSize: R.fontsize.fontSizeBtn,
    color: R.colors.gray4,
  },
  emailPreview: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.gray4,
  },
  attachmentIndicator: {
    width: 20,
    height: 20,
    borderRadius: 10,
    backgroundColor: R.colors.blue3,
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 4,
  },
  attachmentCount: {
    color: R.colors.blue,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    fontSize: R.fontsize.fontSizeContent,
  },
  swipeContainer: {
    position: 'relative',
    overflow: 'hidden',
  },
  deleteBackground: {
    position: 'absolute',
    right: 2.5,
    top: 5,
    bottom: 5,
    width: 95,
    backgroundColor: R.colors.red,
    borderRadius: 25,
    justifyContent: 'center',
    alignItems: 'center',
    flexDirection: 'column',
  },
  deleteButton: {
    width: 100,
    height: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    flexDirection: 'column',
  },
  deleteIcon: {
    width: 24,
    height: 24,
    tintColor: R.colors.white,
    marginBottom: 4,
  },
  deleteText: {
    color: R.colors.white,
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
  },
});

export default styles;
