import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  TextInput,
} from 'react-native';
import styles from './style';
import R from '../../../assets/R';
import {useNavigation} from '@react-navigation/native';
import EmailChipInput from '../../../components/Chip/EmailChipInput';

const SendEmailView = props => {
  const {handleChange, chip, dataList} = props;

  const navigation = useNavigation();

  const renderHeader = () => {
    return (
      <View style={styles.header}>
        <TouchableOpacity onPress={() => navigation.goBack()}>
          <Image source={R.images.icBack} style={styles.icon} />
        </TouchableOpacity>
        <Text style={styles.title}>Soạn email</Text>
        <TouchableOpacity
          onPress={() => navigation.goBack()}
          style={styles.sendButton}>
          <Text style={styles.sendText}>Gửi Đi</Text>
          <Image
            source={R.images.icSend}
            style={styles.iconSend}
            tintColor={R.colors.white}
          />
        </TouchableOpacity>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      {renderHeader()}
      <View style={styles.body}>
        <EmailChipInput
          title="To"
          delimiters={dataList}
          entries={chip}
          onSubmit={handleChange}
          chipContainerStyle={{backgroundColor: R.colors.blue4}}
          chipTextStyle={{color: R.colors.black}}
          containerStyle={{
            borderBottomWidth: 1,
            borderColor: R.colors.grayBorderInputTextHeader,
            borderRadius: 5,
            marginBottom: 10,
          }}
          chipImage={
            <Image
              source={R.images.icCancel}
              style={styles.iconClose}
              tintColor={R.colors.black}
            />
          }
        />
        <EmailChipInput
          title="CC"
          delimiters={dataList}
          entries={chip}
          onSubmit={handleChange}
          chipContainerStyle={{backgroundColor: R.colors.blue4}}
          chipTextStyle={{color: R.colors.black}}
          containerStyle={{
            borderBottomWidth: 1,
            borderColor: R.colors.grayBorderInputTextHeader,
            borderRadius: 5,
            marginBottom: 10,
          }}
          chipImage={
            <Image
              source={R.images.icCancel}
              style={styles.iconClose}
              tintColor={R.colors.black}
            />
          }
        />
        <EmailChipInput
          title="BCC"
          delimiters={dataList}
          entries={chip}
          onSubmit={handleChange}
          chipContainerStyle={{backgroundColor: R.colors.blue4}}
          chipTextStyle={{color: R.colors.black}}
          containerStyle={{
            borderBottomWidth: 1,
            borderColor: R.colors.grayBorderInputTextHeader,
            borderRadius: 5,
            marginBottom: 10,
          }}
          chipImage={
            <Image
              source={R.images.icCancel}
              style={styles.iconClose}
              tintColor={R.colors.black}
            />
          }
        />
        <EmailChipInput
          title="From"
          delimiters={dataList}
          entries={chip}
          onSubmit={handleChange}
          chipContainerStyle={{backgroundColor: R.colors.blue4}}
          chipTextStyle={{color: R.colors.black}}
          containerStyle={{
            borderBottomWidth: 1,
            borderColor: R.colors.grayBorderInputTextHeader,
            borderRadius: 5,
            marginBottom: 10,
          }}
          chipImage={
            <Image
              source={R.images.icCancel}
              style={styles.iconClose}
              tintColor={R.colors.black}
            />
          }
        />
        <View style={styles.inputContainer}>
          <Text
            style={{
              fontSize: 12,
              color: R.colors.black,
              fontFamily: R.fonts.fontMedium,
            }}>
            Subject
          </Text>
          <TextInput
            placeholderTextColor={R.colors.gray}
            style={styles.input}
          />
        </View>
        <View style={[{height: 100, marginTop: 10}]}>
          <TextInput
            placeholderTextColor={R.colors.gray}
            style={[
              styles.input,
              {
                paddingHorizontal: 10,
                borderBottomWidth: 1,
                borderColor: R.colors.grayBorderInputTextHeader,
              },
            ]}
            multiline={true}
            numberOfLines={5}
            textAlignVertical="top"
          />
        </View>
      </View>
    </View>
  );
};

export default SendEmailView;
