import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  SafeAreaView,
} from 'react-native';
import Header from '../../../../components/Header/Header';
import R from '../../../../assets/R';
import styles from './style';
import {useNavigation} from '@react-navigation/native';
import CheckBox from '../../../../components/CheckBox';
const DetailStudentView = props => {
  const {student, onCheckboxChange} = props;
  const navigate = useNavigation();
  const getStatusColor = status => {
    const statusColors = {
      'Đang học': '#4CAF50',
      'Cảnh cáo': '#FF9800',
      'Thôi học': '#F44336',
    };
    return statusColors[status] || '#9E9E9E';
  };
  const statusColor = getStatusColor(student.status);
  
  const renderCard = () => {
    return (
       <View
          style={[
            styles.card,
            styles.cardWithMargin,
          ]}>
          <View style={styles.containerText}>
            <View style={styles.containerTextItemLeft}>
              <Text style={styles.text}>STC TL / STC CTDT 23 / 102</Text>
            </View>
            <View style={styles.sizedBox}></View>
            <View style={styles.containerTextItemRight}>
              <Text style={[styles.text]}>Tình trạng: </Text>
              <Text style={[styles.text, {color: statusColor}]}>
                {student.status}
              </Text>
            </View>
          </View>
          {/*Row 2*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Ngày sinh:{' '}
                <Text
                  style={[
                    styles.text,
                    styles.regularText,
                  ]}>
                  {student.date_student}
                </Text>
              </Text>
            </View>
            <View style={styles.sizedBox}></View>
            <View style={styles.containerSubTextItemRight}>
              <Text style={[styles.text]}>
                SDT:{' '}
                <Text
                  style={[
                    styles.text,
                    styles.regularText,
                  ]}>
                  {student.tele_phone}
                </Text>
              </Text>
            </View>
          </View>
          {/*Row 3*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Giới tính:{' '}
                <Text
                  style={[
                    styles.text,
                    styles.regularText,
                  ]}>
                  {student.gender}
                </Text>
              </Text>
            </View>
            <View style={styles.sizedBox}></View>
            <View style={styles.containerSubTextItemRight}>
              <Text style={[styles.text]}>
                Điểm trung bình:{' '}
                <Text
                  style={[
                    styles.text,
                    styles.regularText,
                  ]}>
                  {student.average_score}
                </Text>
              </Text>
            </View>
          </View>

          {/*Row 4*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Điểm TB học kì gần nhất:{' '}
                <Text
                  style={[
                    styles.text,
                    styles.regularText,
                  ]}>
                  {student.average_score}
                </Text>
              </Text>
            </View>
          </View>
          {/*Row 5*/}
          <View style={styles.containerSubText}>
            <View style={styles.containerSubTextItemLeft}>
              <Text style={[styles.text]}>
                Điểm rèn luyện TB:{' '}
                <Text
                  style={[
                    styles.text,
                    styles.regularText,
                  ]}>
                  {student.training_average_score}
                </Text>
              </Text>
            </View>
          </View>

          {/*Row 6*/}
          <View style={styles.checkboxContainer}>
            {student.type.map((item, index) => (
              <View key={item.id} style={styles.checkboxItem}>
                <CheckBox
                  value={item.status}
                  onValueChange={value => onCheckboxChange(item.id, value)}
                  size={20}
                  labelStyle={styles.label}
                  checkedColor={R.colors.main}
                  tickColor={R.colors.white}
                  label={item.name}
                  imageStyle={styles.imageStyle}
                />
              </View>
            ))}
          </View>
        </View>
    )
  }

  const renderCardHistory = () =>{
    return (
      <View
          style={[
            styles.containerCard,
            {backgroundColor: getStatusColor(student.status)},
          ]}>
          <Text
            style={styles.statusHeaderText}>
            Trạng thái học tập:{' '}
            <Text style={[styles.text, styles.statusText]}>
              {student.status}
            </Text>
          </Text>
          <View style={styles.card}>
            <Text
              style={styles.historyCardText}>
              Học kỳ 2, Năm học 2024
            </Text>

            <Text
              style={styles.historyCardText}>
              Ngày quyết định:{' '}
              <Text
                style={[
                  styles.text,
                  styles.regularText,
                ]}>
                {student.date_student}
              </Text>
            </Text>

            <Text
              style={styles.historyCardText}>
              Lý do:{' '}
              <Text
                style={[
                  styles.text,
                  styles.regularText,
                ]}>
                {student.date_student}
              </Text>
            </Text>

            <Text
              style={styles.historyCardText}>
              Ghi chú:{' '}
              <Text
                style={[
                  styles.text,
                  styles.regularText,
                ]}>
                {student.date_student}
              </Text>
            </Text>
          </View>
        </View>
    )
  }

  const renderBody = () => {
    return (
        <View style={styles.body}>
        {renderCard()}
        <Text style={[styles.textTitle, styles.textTitleWithMargin]}>
          Lịch sử tình trạng của sinh viên
        </Text>
        {renderCardHistory()}
      </View>
    )

  };

  return (
    <View style={styles.container}>
      <Header title={'Nguyễn Minh Đức - 2598671'} isBack />
    {renderBody()}
    </View>
  );
};

export default DetailStudentView;
