import React from 'react';
import {
  Modal,
  View,
  Text,
  TouchableOpacity,
  ScrollView,
  Image,
  FlatList,
} from 'react-native';
import R from '../../../assets/R';
import styles from './style';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import Button from '../../../components/Button';

const AddMonitoringModalView = props => {
  const {
    visible,
    formData,
    dataList,
    selectedItems,
    updateFormData,
    handleSave,
    handleClose,
    handleSelectItem,
    handleRemoveItem,
  } = props;

  const renderItem = ({item}) => {
    const isSelected = selectedItems.some(selected => selected.id === item.id);
    return (
      <TouchableOpacity
        style={[styles.chip, isSelected && styles.chipSelected]}
        onPress={() => handleSelectItem(item)}>
        <Text style={[styles.textChip, isSelected && styles.textChipSelected]}>
          {item.name}
        </Text>
      </TouchableOpacity>
    );
  };

  const renderSelectedItem = ({item}) => {
    return (
      <View style={styles.selectedChip}>
        <TouchableOpacity
          style={styles.containerIcon}
          onPress={() => handleRemoveItem(item.id)}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}>{item.name}</Text>
      </View>
    );
  };

  return (
    <Modal
      visible={visible}
      transparent={true}
      animationType="slide"
      onRequestClose={handleClose}>
      <View style={styles.overlay}>
        <View style={styles.modalContainer}>
          <ScrollView showsVerticalScrollIndicator={false}>
            <Text style={styles.title}>Tạo công việc giám sát</Text>

            <TextField
              title="Tiêu đề công việc"
              placeholder="Nhập tiêu đề công việc"
              required={true}
              value={formData.title}
              onChangeText={value => updateFormData('title', value)}
              containerMarginBottom={15}
            />

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>
                Loại công việc <Text style={styles.required}>*</Text>
              </Text>
              <Dropdown
                height={35}
                placeholder="Chọn loại công việc"
                onSelect={item => updateFormData('category', item)}
              />
            </View>

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>
                Người chịu trách nhiệm <Text style={styles.required}>*</Text>
              </Text>
              <Dropdown
                height={35}
                placeholder="Chọn người chịu trách nhiệm"
                onSelect={item => updateFormData('responsible', item)}
              />
            </View>

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>
                Thời hạn hoàn thành <Text style={styles.required}>*</Text>
              </Text>
              <Dropdown
                height={35}
                placeholder="Chọn thời hạn"
                onSelect={item => updateFormData('deadline', item)}
              />
            </View>

            <TextMulti
              title="Nội dung công việc"
              placeholder="Nhập nội dung chi tiết công việc cần giám sát"
              required={true}
              value={formData.content}
              onChangeText={value => updateFormData('content', value)}
              containerMarginBottom={15}
            />

            <View style={styles.containerDropdown}>
              <Text style={styles.label}>
                Người thực hiện <Text style={styles.required}>*</Text>
              </Text>
              <Dropdown
                height={35}
                placeholder="Chọn người thực hiện"
                onSelect={item => updateFormData('implementer', item)}
              />
            </View>

            <Text style={styles.label}>Danh sách người thực hiện:</Text>
            <FlatList
              data={dataList}
              renderItem={renderItem}
              keyExtractor={item => item.id.toString()}
              numColumns={2}
              style={styles.flatList}
              showsVerticalScrollIndicator={false}
              columnWrapperStyle={styles.flatListRow}
              nestedScrollEnabled={true}
              scrollEnabled={false}
            />

            <Text style={styles.label}>Đã chọn:</Text>
            <FlatList
              data={selectedItems}
              renderItem={renderSelectedItem}
              keyExtractor={item => item.id.toString()}
              numColumns={2}
              style={styles.selectedFlatList}
              showsVerticalScrollIndicator={false}
              columnWrapperStyle={styles.flatListRow}
              nestedScrollEnabled={true}
              scrollEnabled={false}
            />

            <Text style={styles.label}>Tài liệu đính kèm</Text>
            <TouchableOpacity style={styles.attachmentContainer}>
              <Image source={R.images.icDocument} style={styles.uploadIcon} />
              <Text style={styles.attachmentText}>Thêm tài liệu</Text>
            </TouchableOpacity>

            <View style={styles.buttonContainer}>
              <Button
                title="Hủy"
                onPress={handleClose}
                backgroundColor={R.colors.orange}
                width={100}
                height={35}
                borderRadius={100}
                marginRight={10}
                fontSize={R.fontsize.fontSizeContent}
                textColor={R.colors.white}
              />
              <Button
                title="Tạo công việc"
                onPress={handleSave}
                backgroundColor={R.colors.blue}
                width={120}
                height={35}
                borderRadius={100}
                fontSize={R.fontsize.fontSizeContent}
                textColor={R.colors.white}
              />
            </View>
          </ScrollView>
        </View>
      </View>
    </Modal>
  );
};

export default AddMonitoringModalView;
