import React, {useState} from 'react';
import {Text, View, StyleSheet} from 'react-native';
import IncomingDocumentView from './view';

const IncomingDocument = props => {
  const [activeTab, setActiveTab] = useState('all');
  const [dataListTabView, setDataListTabView] = useState([
    {
      key: 'all',
      title_status: 'Tất cả',
    },
    {
      key: 'restrict',
      title_status: 'Đã hạn chế',
    },
    {
      key: 'public',
      title_status: 'Công khai',
    },
  ]);

  const handleTabKey = tabKey => {
    setActiveTab(tabKey);
  };

  const [dataList, setDataList] = useState([
    {
      id: '1',
      title: 'Văn bản thông báo lịch nộp thời khoá biểu của học kì 2 năm 2025',
      symbol_number: '123456789',
      term: '29/07/2025',
      number_entry_book: '12493-fh544',
      status: 'Hạn chế',
      total_head_of_work: '12',
    },
    {
      id: '2',
      title: 'Văn bản thông báo lịch nộp thời khoá biểu của học kì 2 năm 2025',
      symbol_number: '123456789',
      term: '29/07/2025',
      number_entry_book: '12493-fh544',
      status: 'Công khai',
    },
  ]);

  const [searchQuery, setSearchQuery] = useState('');

  const filterData = dataList.filter(item => {
    const matchTab = activeTab == 'all' || item.status == activeTab;
    const matchSearch = item.title
      .toLowerCase()
      .includes(searchQuery.toLowerCase());
    return matchTab && matchSearch;
  });

  return (
    <IncomingDocumentView
      activeTab={activeTab}
      dataListTabView={dataListTabView}
      dataList={filterData}
      searchQuery={searchQuery}
      setSearchQuery={setSearchQuery}
      handleTabKey={handleTabKey}
    />
  );
};

export default IncomingDocument;
