import {
  Image,
  StyleSheet,
  TextInput,
  View,
  Platform,
  SafeAreaView,
  StatusBar,
} from 'react-native';
import React from 'react';
import R from '../../assets/R';
import styles from './style';
const HeaderHome = props => {
  const {value, onChangeText} = props;
  return (
    <SafeAreaView style={styles.containerBoxHeader}>
      <StatusBar
        barStyle="light-content"
        translucent={false}
        backgroundColor="black"
      />
      <View style={styles.boxLogo}>
        <Image
          source={R.images.igLogo}
          maxWidth={Platform.OS === 'ios' ? 65 : 75}
          maxHeight={Platform.OS === 'ios' ? 26 : 36}
          resizeMode="contain"
        />
      </View>
      <View style={{flex: 1}}></View>
      <View style={styles.searchBox}>
        <View style={styles.boxIconSearch}>
          <Image
            source={R.images.icSearchHeader}
            maxWidth={Platform.OS === 'ios' ? 16 : 20}
            maxHeight={Platform.OS === 'ios' ? 16 : 20}
          />
        </View>
        <TextInput
          value={value}
          fontSize={R.fontsize.fontSizeContent}
          onChangeText={onChangeText}
          placeholder={'Tìm kiếm'}
          placeholderTextColor={R.colors.white}
          style={styles.input}
        />
      </View>
    </SafeAreaView>
  );
};

export default HeaderHome;
