import React from 'react';
import {Text, View, TouchableOpacity, StyleSheet, FlatList} from 'react-native';
import styles from './style';
import Header from '../../../components/Header/Header';
import R from '../../../assets/R';
import Button from '../../../components/Button';
const DetailCompensateView = props => {
  const {item, listData, itemDetail} = props;

  const getColor = status => {
    switch (status) {
      case 'Đã xác nhận':
        return R.colors.green1;
      case 'Chờ phê duyệt':
        return R.colors.blue;
      case 'Từ chối':
        return R.colors.red;
    }
  };
  const renderItem = ({item}) => {
    return (
      <View style={styles.card}>
        <View
          style={{
            backgroundColor: R.colors.white,
            borderTopRightRadius: 10,
            borderTopLeftRadius: 10,
          }}>
          <View
            style={{
              borderTopRightRadius: 10,
              borderTopLeftRadius: 10,
              backgroundColor: getColor(item.status),
            }}>
            <Text
              style={[
                styles.text,
                {
                  fontSize: R.sizes.sm,
                  paddingHorizontal: 10,
                  paddingVertical: 2,
                  color: R.colors.white,
                  fontWeight: 'bold',
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              <Text style={{fontSize: R.sizes.sm, color: R.colors.white}}>
                {item.status}
              </Text>
            </Text>
          </View>
        </View>

        <View style={{paddingHorizontal: 10, paddingTop: 3, paddingBottom: 10}}>
          {/* Row 1 */}
          <View
            style={{
              flexDirection: 'row',
            }}>
            <View style={{flex: 1}}>
              <Text
                style={[
                  styles.text,
                  {
                    fontSize: R.fontsize.fontSizeContent,
                    fontWeight: 600,
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Ngày báo nghỉ:{' '}
                <Text
                  style={{
                    fontSize: R.fontsize.fontSizeContent,
                    fontWeight: 400,
                    fontFamily: R.fonts.fontRegular,
                  }}>
                  {item.date}
                </Text>
              </Text>
            </View>
            {/* <View style={{flex: 1}}>
              <Text style={[styles.text, {fontSize: R.sizes.sm}]}>
                Tình trạng: <Text style={{color: getColor(item.status)}}>{item.status}</Text>
              </Text>
            </View> */}
          </View>
          {/* Row 2 */}
          <View>
            <Text
              style={[
                styles.text,
                {
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 600,
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              Thời gian nghỉ:{' '}
              <Text
                style={{
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 400,
                  fontFamily: R.fonts.fontRegular,
                }}>
                {item.dayOfWeek} - Tiết:{' '}
                {item.periods.map((item, index) => {
                  return <Text key={index}>{item.time},</Text>;
                })}
                - Ngày: {''}
                {item.dateStudy}
              </Text>
            </Text>
          </View>
          {/* Row 3 */}
          <View style={{}}>
            <Text
              style={[
                styles.text,
                {
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 600,
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              Địa điểm:{' '}
              <Text
                style={{
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 400,
                  fontFamily: R.fonts.fontRegular,
                }}>
                {item.location}
              </Text>
            </Text>
          </View>
          {/* Row 4 */}
          <View style={{}}>
            <Text
              style={[
                styles.text,
                {
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 600,
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              Giảng viên thay thế:{' '}
              <Text
                style={{
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 400,
                  fontFamily: R.fonts.fontRegular,
                }}>
                {item.teacher}
              </Text>
            </Text>
          </View>
          {/* Row 5 */}
          <View style={{}}>
            <Text
              style={[
                styles.text,
                {
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 600,
                  fontFamily: R.fonts.fontMedium,
                },
              ]}>
              Ghi chú:{' '}
              <Text
                style={{
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: 400,
                  fontFamily: R.fonts.fontRegular,
                }}>
                {item.note}
              </Text>
            </Text>
          </View>

          {item.status === 'Chờ phê duyệt' && (
            <View style={{alignItems: 'flex-end'}}>
              <Button
                title="Huỷ"
                onPress={() => {}}
                backgroundColor={R.colors.orange}
                textColor={R.colors.white}
                height={25}
                width={90}
                borderRadius={15}
                fontSize={R.fontsize.fontSizeContent}
                fontWeight={'600'}
                fontFamily={R.fonts.fontMedium}
                paddingHorizontal={15}
              />
            </View>
          )}
        </View>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'ATTT2024.1'} isBack />
      <View style={styles.body}>
        <View style={{alignItems: 'center', marginTop: 10}}>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Nghỉ / Bù / Tổng
          </Text>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 400,
                fontFamily: R.fonts.fontRegular,
              },
            ]}>
            {itemDetail?.rest} / {itemDetail?.compensate} / {itemDetail?.total}
          </Text>
        </View>
        <FlatList
          data={listData || []}
          renderItem={renderItem}
          showsVerticalScrollIndicator={false}
          vertical
          keyExtractor={(item, index) => `${index}`}
        />
      </View>
    </View>
  );
};

export default DetailCompensateView;
