import React from 'react';
import {View, Text, TextInput} from 'react-native';
import {WIDTHXD, getFontXD, WIDTH, HEIGHT} from '../../config/Functions';
import R from '../../assets/R';
import {RFValue} from 'react-native-responsive-fontsize';
const TextField = props => {
  const {
    title,
    onChangeText,
    isPassword,
    maxLength,
    isNumber,
    value,
    editable,
    error,
    placeholder,
    backgroundColor,
    onFocus,
    fontSize = R.fontsize.fontSizeContent,
    fontSizeTitle = R.fontsize.fontSizeContent,
    color,
    required,
    containerMarginVertical,
    containerMarginTop,
    containerMarginHorizontal,
    containerMarginBottom,
    containerBackgroundColor,
    width,
    fontFamily = R.fonts.fontMedium,
  } = props;
  const renderMess = () => {
    if (value && value.trim().length > 0) return `${title} không hợp lệ`;
    return `Vui lòng nhập ${title ? title.toLowerCase() : messageError} `;
  };

  return (
    <View style={{width:width,marginVertical: containerMarginVertical, marginHorizontal: containerMarginHorizontal, marginBottom: containerMarginBottom , backgroundColor: containerBackgroundColor, marginTop: containerMarginTop}}>
      <Text
        style={{
          fontSize: fontSizeTitle,
          color: R.colors.black,
          marginBottom: 5,
          fontFamily:fontFamily,
          fontWeight:'600',

        }}>
        {title ? title : ''}
        <Text style={{color: R.colors.red}}> {required ? "*" : ""}</Text>
      </Text>
      <TextInput

        placeholder={placeholder}
        maxLength={maxLength ? maxLength : 256}
        placeholderTextColor= {
          editable === false 
      ? (backgroundColor || R.colors.black) // khi disabled thì lấy màu xám
      : backgroundColor        }
        editable={editable != null ? editable : true}
        secureTextEntry={isPassword}
        autoCapitalize="none"
        value={value}
        onFocus={onFocus}
        keyboardType={isNumber ? 'number-pad' : 'default'}
        onChangeText={val => onChangeText(val)}
        style={{
          height: HEIGHT(35),
          color: color,
          borderColor:R.colors.grayBorderInputTextHeader,
          borderWidth:1,
          borderRadius: HEIGHT(6),
          fontSize: fontSize,
          paddingVertical: 5,
          paddingHorizontal: 10,
          backgroundColor:  editable === false 
      ? (backgroundColor || R.colors.blue1) // khi disabled thì lấy màu xám
      : backgroundColor, // khi enable thì lấy màu bạn truyền,
        }}
      />
      {error && <View
        style={{
          height: HEIGHT(20),
          marginTop: 5,
        }}>
        {error && !error.ref?.value && (
          <Text
            ellipsizeMode={'tail'}
            numberOfLines={1}
            style={{
              flex: 1,
              color: R.colors.red,
              fontSize: RFValue(10),
            }}>
            {error.message ? error.message : renderMess()}
          </Text>
        )}
      </View>}
    </View>
  );
};

export default React.memo(TextField);
