import {StyleSheet, Text, View} from 'react-native';
import R from '../../assets/R';
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    padding: 15,
  },
  headerBody: {
    flexDirection: 'row',
    marginBottom: 15,
  },
  headerLeft: {
    // backgroundColor:'red'
  },
  boxCamera: {
    alignItems: 'center',
    justifyContent: 'center',
    maxWidth: 120,
  },
  containerImage: {
    backgroundColor: R.colors.grayBorderInputTextHeader,
    width: 100,
    height: 150,
    justifyContent: 'center',
    alignItems: 'center',
    borderRadius: 10,
  },
  image: {
    width: 100,
    height: 150,
    borderRadius: 10,
  },
  containerButton: {
    marginTop: 10,
  },

  headerRight: {
    flex: 1,
    marginLeft: 15,
    justifyContent: 'flex-start',
  },
  text: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  bodyProfile: {},
  containerInput: {
    flexDirection: 'row',
    marginBottom: 15,
    justifyContent: 'space-between',
  },
  sizedBox: {
    width: 15,
  },

  overlay: { position: 'absolute', top: 0, left: 0, right: 0, bottom: 0, backgroundColor: 'black' },
  controls: { position: 'absolute', bottom: 30, left: 0, right: 0, flexDirection: 'row', justifyContent: 'space-around', alignItems: 'center' },
  shutter: { width: 68, height: 68, borderRadius: 34, borderWidth: 4, borderColor: '#fff', backgroundColor: 'rgba(255,255,255,0.2)' },
  smallBtn: { paddingHorizontal: 12, paddingVertical: 8, borderRadius: 8, backgroundColor: 'rgba(255,255,255,0.2)' },
  btnText: { color: '#fff', fontWeight: '600' },
  absoluteFill: { position: 'absolute', top: 0, left: 0, right: 0, bottom: 0 },
  center: { justifyContent: 'center', alignItems: 'center' },
});
export default styles;
