import React from 'react';
import {Text, View, StyleSheet} from 'react-native';
import ApprovalView from './view';
import {useState} from 'react';

const Approval = props => {
  const [icomingDocument, setIncomingDocument] = useState({
    id: 102934,
    title: 'Văn bản thông báo lịch nộp thời khoá biểu của học kỳ 2 năm 2025',
    status: 'Hạn chế',
    symbol_number: '2038475',
    regime: 'Chờ phê duyệt  ',
    number_entry_book: '12493-fh544',
    term: '29/07/2025',
    term_display: '09/07/2025',
    document_date: '2025-07-08',
    document_date_display: '08/07/2025',
    document_type: 'Hành chính',
    field: 'Thời khoá biểu',
    signer_name: 'Nguyễn Minh Đức',
    sender_partner: 'Võ Công Bình',
    note: '',
    content:
      'Ban lãnh đạo yêu cầu hoàn thành thời khoá biểu trong tháng cho các đơn vị chuyên môn, nộp đầy đủ công việc theo đúng kế hoạch.',
    opinion_bgh: 'Thực hiện nhanh công tác thời khoá biểu',
    received_departments: [
      {id: 1, name: 'Phòng đào tạo'},
      {id: 2, name: 'Phòng đào tạo'},
    ],
    received_group: [{id: 12, name: 'Nhóm chuyên môn đào tạo'}],
    receiver: [{id: 55, name: 'Nguyễn Minh Đức'}],
    attachments: [
      {
        id: '001247363',
        filename: 'Quyết định thông báo đào tạo - 001247363',
        file_ext: 'pdf',
        file_size: 0,
        download_url: '#',
        preview_url: '#',
      },
    ],
    total_head_of_work: 7,
    approvals: [
      {
        author: 'Bút Tiến Công',
        code: '08569',
        date: '29/07/2025',
        time: '16:00',
        content:
          'Ban lãnh đạo yêu cầu hoàn thành thời khoá biểu trong tháng cho các đơn vị chuyên môn, nộp đầy đủ công việc theo đúng kế hoạch.',
      },
      {
        author: 'Nguyễn Thị Kim Phụng',
        code: '08569',
        date: '29/07/2025',
        time: '16:00',
        content: 'Trưởng phòng xác nhận hợp bộ hồ sơ.',
      },
      {
        author: 'Đặng Duy Minh',
        code: '08569',
        date: '29/07/2025',
        time: '16:00',
        content: 'Trưởng phòng nhập công bố quyết định nội bộ.',
      },
    ],
    actions: {
      can_create_task: true,
      create_task_label: 'Tạo công việc',
    },
  });
  const items = [
    {id: 1, label: 'Option 1'},
    {id: 2, label: 'Option 2'},
    {id: 3, label: 'Option 3'},
  ];
  const [dataList, setDataList] = useState([
    {id: 1, name: 'Nguyễn Minh Đức'},
    {id: 2, name: 'Trần Văn Hùng'},
    {id: 3, name: 'Lê Thị Mai'},
    {id: 4, name: 'Phạm Quốc Khánh'},
    {id: 5, name: 'Hoàng Anh Tuấn'},
    {id: 6, name: 'Vũ Thị Hằng'},
    {id: 7, name: 'Ngô Văn Nam'},
    {id: 8, name: 'Đinh Thị Lan'},
    {id: 9, name: 'Bùi Văn Phúc'},
    {id: 10, name: 'Lý Thị Hoa'},
    {id: 11, name: 'Phan Minh Hoàng'},
    {id: 12, name: 'Tạ Thị Hương'},
    {id: 13, name: 'Đoàn Văn Dũng'},
    {id: 14, name: 'Nguyễn Thị Vân'},
    {id: 15, name: 'Trương Văn Long'},
    {id: 16, name: 'Mai Thị Ngọc'},
    {id: 17, name: 'Huỳnh Quốc Việt'},
    {id: 18, name: 'Lâm Thị Thu'},
    {id: 19, name: 'Nguyễn Hữu Tài'},
    {id: 20, name: 'Phạm Thị Kim'},
  ]);

  return (
    <ApprovalView
      icomingDocument={icomingDocument}
      items={items}
      dataList={dataList}
    />
  );
};

export default Approval;
