import React, {useState, useEffect} from 'react';
import EmailHomeView from './view';

const EmailHome = props => {
  const [emails, setEmails] = useState([]);
  const [loading, setLoading] = useState(true);

  // Fake API data
  const generateFakeEmails = () => {
    const today = new Date();
    const yesterday = new Date(today);
    yesterday.setDate(yesterday.getDate() - 1);

    const weekAgo = new Date(today);
    weekAgo.setDate(weekAgo.getDate() - 7);

    const monthAgo = new Date(today);
    monthAgo.setMonth(monthAgo.getMonth() - 1);

    return [
      {
        id: 1,
        sender: 'Nguyễn Minh Đức',
        subject: 'Bảng lương tháng 10',
        preview:
          'Kính gửi nhân viên ưu tú đây là bảng lương tháng 10 của bạn hãy kiểm tra nếu có thắc...',
        date: today,
        isRead: true,
        hasAttachment: false,
        avatar: 'https://via.placeholder.com/40',
      },
      {
        id: 2,
        sender: 'Vũ Công Bình',
        subject: 'Re: ĐƠN XIN ỨNG LƯƠNG',
        preview:
          'Kính gửi nhân viên ưu tú đây là bảng lương tháng 10 của bạn hãy kiểm tra nếu có thắc...',
        date: yesterday,
        isRead: false,
        hasAttachment: true,
        avatar: 'https://via.placeholder.com/40',
      },
      {
        id: 3,
        sender: 'Vũ Công Bình',
        subject: 'Re: ĐƠN XIN ỨNG LƯƠNG',
        preview:
          'Kính gửi nhân viên ưu tú đây là bảng lương tháng 10 của bạn hãy kiểm tra nếu có thắc...',
        date: yesterday,
        isRead: false,
        hasAttachment: true,
        avatar: 'https://via.placeholder.com/40',
      },
      {
        id: 4,
        sender: 'Trần Thị Mai',
        subject: 'Thông báo họp tuần',
        preview:
          'Cuộc họp tuần sẽ được tổ chức vào thứ 2 tuần tới lúc 9h00 sáng tại phòng họp A...',
        date: weekAgo,
        isRead: true,
        hasAttachment: false,
        avatar: 'https://via.placeholder.com/40',
      },
      {
        id: 5,
        sender: 'Phòng Nhân Sự',
        subject: 'Thông báo nghỉ lễ',
        preview:
          'Công ty thông báo lịch nghỉ lễ Quốc Khánh 2/9 từ ngày 31/8 đến 3/9...',
        date: monthAgo,
        isRead: true,
        hasAttachment: false,
        avatar: 'https://via.placeholder.com/40',
      },
    ];
  };

  // Logic để format ngày hiển thị
  const formatEmailDate = emailDate => {
    const today = new Date();
    const yesterday = new Date(today);
    yesterday.setDate(yesterday.getDate() - 1);

    // Reset time để so sánh chỉ ngày
    const emailDateOnly = new Date(
      emailDate.getFullYear(),
      emailDate.getMonth(),
      emailDate.getDate(),
    );
    const todayOnly = new Date(
      today.getFullYear(),
      today.getMonth(),
      today.getDate(),
    );
    const yesterdayOnly = new Date(
      yesterday.getFullYear(),
      yesterday.getMonth(),
      yesterday.getDate(),
    );

    if (emailDateOnly.getTime() === todayOnly.getTime()) {
      return 'Hôm nay';
    } else if (emailDateOnly.getTime() === yesterdayOnly.getTime()) {
      return 'Tuần trước';
    } else {
      // Format: dd/mm/yyyy
      const day = emailDate.getDate().toString().padStart(2, '0');
      const month = (emailDate.getMonth() + 1).toString().padStart(2, '0');
      const year = emailDate.getFullYear();

      return `${day}/${month}/${year}`;
    }
  };
  //Nhóm các email trong danh sách theo ngày trả về một đối tượng trong đó các khoá là ngày
  const groupEmailsByDate = emailList => {
    const grouped = {};

    emailList.forEach(email => {
      const dateLabel = formatEmailDate(email.date);
      if (!grouped[dateLabel]) {
        grouped[dateLabel] = [];
      }
      grouped[dateLabel].push(email);
    });

    return grouped;
  };

  useEffect(() => {
    setTimeout(() => {
      const fakeEmails = generateFakeEmails();
      setEmails(fakeEmails);
      setLoading(false);
    }, 1000);
  }, []);

  const handleEmailPress = email => {
    console.log('Email pressed:', email.subject);
  };

  const handleRefresh = () => {
    setLoading(true);
    setTimeout(() => {
      const fakeEmails = generateFakeEmails();
      setEmails(fakeEmails);
      setLoading(false);
    }, 1000);
  };

  const groupedEmails = groupEmailsByDate(emails);

  return (
    <EmailHomeView
      emails={emails}
      groupedEmails={groupedEmails}
      loading={loading}
      onEmailPress={handleEmailPress}
      onRefresh={handleRefresh}
      formatEmailDate={formatEmailDate}
    />
  );
};

export default EmailHome;
