import {StyleSheet} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    marginHorizontal: 15,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
  },
  sub_text: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
  },
  containerCard: {
    borderWidth: 1,
    borderRadius: 10,
    padding: 10,
    marginBottom: 10,
    borderColor: R.colors.grayBorderInputTextHeader,
    backgroundColor: R.colors.white,
  },
  containerText: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderRadius: 5,
  },
  textChip: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
  containerContent: {
    borderWidth: 1,
    borderRadius: 10,
    padding: 10,
    marginVertical: 5,
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  flatListSelect: {
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  chip: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingLeft: 10,
    paddingRight: 10,
    height: 25,
    borderRadius: 10,
    marginBottom: 10,
    marginRight: 5,
    backgroundColor: R.colors.blue2,
    alignSelf: 'flex-start',
  },
  imageIcon: {
    width: 15,
    height: 15,
  },
  containerIcon: {
    marginRight: 2,
  },
  attachmentContainer: {
    borderWidth: 1,
    borderColor: R.colors.blue,
    borderRadius: 10,
    padding: 20,
    alignItems: 'center',
    marginTop: 3,
    marginBottom: 50,
  },
  uploadIcon: {
    width: 23,
    height: 28,
    tintColor: R.colors.blue,
    marginBottom: 5,
  },
  attachmentText: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.blue,
    fontWeight: '500',
  },
  sizedBox: {
    height: 10,
  },
  fab: {
    position: 'absolute',
    bottom: 20,
    right: 20,
  },
  containerFile: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    borderRadius: 10,
    backgroundColor: R.colors.blue1,
    marginBottom: 5,
    height: 30,
    paddingHorizontal: 10,
  },
  image: {
    width: 20,
    height: 20,
  },
  cardContent: {
    borderWidth: 1,
    borderRadius: 10,
   
    marginVertical: 3,
    borderColor: R.colors.grayBorderInputTextHeader,
    backgroundColor: R.colors.white,
  }
});

export default styles;
