import React, {useState, useEffect} from 'react';
import EditReportModalView from './view';

const EditReportModal = ({visible, onClose, onSubmit, initialContent = ''}) => {
  const [reportContent, setReportContent] = useState(initialContent);

  useEffect(() => {
    setReportContent(initialContent);
  }, [initialContent]);

  const handleSubmit = () => {
    if (reportContent.trim()) {
      onSubmit(reportContent);
      onClose();
    }
  };

  const handleCancel = () => {
    setReportContent(initialContent);
    onClose();
  };

  const handleContentChange = (content) => {
    setReportContent(content);
  };

  const handleDeleteAttachment = () => {
  };

  const handleAddAttachment = () => {
  };

  return (
    <EditReportModalView
      visible={visible}
      onClose={onClose}
      reportContent={reportContent}
      onContentChange={handleContentChange}
      onSubmit={handleSubmit}
      onCancel={handleCancel}
      onDeleteAttachment={handleDeleteAttachment}
      onAddAttachment={handleAddAttachment}
    />
  );
};

export default EditReportModal;
