import React from 'react';
import {Text, View, ScrollView} from 'react-native';
import styles from './style';
import Header from '../../../components/Header/Header';
import TextField from '../../../components/Input/TextField';
import R from '../../../assets/R';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import TextMulti from '../../../components/Input/TextMulti';
import Button from '../../../components/Button';
import CheckBox from '../../../components/CheckBox';
const CompensateRegisterView = props => {
  const {
    isShow,
    scheduleData,
    onCheckboxChange,
    handleToggle,
    onSave,
    onChange,
    formData,
  } = props;

  console.log(props?.formData);

  const getCheckColor = item => {
    if (item?.breakTime === item?.totalSession && item?.percent === '100%') {
      return R.colors.blue;
    }
    return R.colors.red;
  };

  //Header Lịch học
  const renderHeaderSchedule = () => {
    return (
      <View style={styles.headerRow}>
        <View style={[styles.dateColumn, {minWidth: 80}]}>
          <Text style={styles.headerText}>Thứ / Tiết</Text>
        </View>

        {Array.from({length: 15}, (_, i) => (
          <View
            key={i}
            style={[styles.periodColumn, {backgroundColor: R.colors.blue3}]}>
            <Text style={styles.headerText}>Tiết {i + 1} </Text>
          </View>
        ))}
      </View>
    );
  };

  const renderForm = () => {
    return (
      <View>
        <View style={styles.containerInput}>
          <TextField
            title={'Học kì'}
            color={R.colors.black}
            fontSize={R.sizes.sm}
            backgroundColor={R.colors.gray}
            required
            editable={false}
            fontSizeTitle={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
            width={'48%'}
          />
          <View style={styles.sizedBox}></View>
          <TextField
            title={'Năm học'}
            color={R.colors.black}
            fontSize={R.sizes.sm}
            editable={false}
            backgroundColor={R.colors.gray}
            required
            fontSizeTitle={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
            width={'48%'}
          />
        </View>
        <View style={styles.containerInput}>
          <TextField
            title={'Mã CBGV'}
            color={R.colors.black}
            editable={false}
            fontSize={R.sizes.sm}
            required
            backgroundColor={R.colors.gray}
            fontSizeTitle={R.sizes.sm}
            width={'100%'}
            containerBackgroundColor={R.colors.white}
          />
        </View>
        <View style={styles.containerDropDown}>
          <View style={{flexDirection: 'row'}}>
            <Text style={[styles.txtSubtitle, {marginBottom: 5}]}>Mã lớp </Text>
            <Text style={{color: R.colors.red}}>*</Text>
          </View>
          <Dropdown title={'Giảng viên thay thế'} />
        </View>
        <View style={styles.containerDropDown}>
          <View style={{flexDirection: 'row'}}>
            <Text style={[styles.txtSubtitle, {marginBottom: 5}]}>
              Lịch báo cần bù{' '}
            </Text>
            <Text style={{color: R.colors.red}}>*</Text>
          </View>
          <Dropdown title={'Lịch báo cần bù'} />
        </View>
        <View style={styles.containerInput}>
          <TextField
            title={'Số tiết đã nghỉ'}
            value={formData.numberOfPeriods}
            onChangeText={onChange('numberOfPeriods')}
            color={R.colors.black}
            fontSize={R.sizes.sm}
            backgroundColor={R.colors.white}
            fontSizeTitle={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
            width={'38%'}
          />
          <View style={styles.sizedBox}></View>
          <TextField
            title={'Ngày học bù'}
            color={R.colors.black}
            value={formData.makeUpDay}
            onChangeText={onChange('makeUpDay')}
            fontSize={R.sizes.sm}
            backgroundColor={R.colors.white}
            required
            fontSizeTitle={R.sizes.sm}
            containerBackgroundColor={R.colors.white}
            width={'58%'}
          />
        </View>
        <TextMulti
          title={'Ghi chú'}
          color={R.colors.black}
          value={formData.note}
          onChangeText={onChange('note')}
          fontSize={R.sizes.sm}
          titleFontSize={R.sizes.sm}
          containerMarginBottom={15}
          containerBackgroundColor={R.colors.white}
        />
        <View style={styles.btnRegister}>
          <Button
            title={isShow ? 'Đóng' : 'Xem lịch rảnh SV'}
            textColor={R.colors.white}
            onPress={handleToggle}
            backgroundColor={R.colors.blue}
            fontSize={R.sizes.sm}
            fontFamily={R.fonts.fontMedium}
            height={35}
            containerStyle={{paddingHorizontal: 15, borderRadius: 10}}
          />
        </View>
      </View>
    );
  };

  const renderRow = (dayData, index) => {
    return (
      <View key={index} style={styles.dataRow}>
        <View style={styles.dateBody}>
          <Text
            style={[
              styles.dateText,
              {textAlign: 'center', paddingHorizontal: 2},
            ]}>
            {dayData.date}
          </Text>
        </View>

        {dayData.periods.map((period, periodIndex) => (
          <View key={periodIndex} style={styles.periodBody}>
            <View
              style={[
                styles.periodCell,
                period.available && styles.availableCell,
              ]}>
              <CheckBox
                checked={period.available}
                value={period.available}
                onValueChange={value =>
                  onCheckboxChange(index, periodIndex, value)
                }
                size={20}
                labelStyle={styles.label}
                checkedColor={R.colors.main}
                tickColor={R.colors.white}
              />
              <View style={{flexDirection: 'row'}}>
                <Text
                  style={[
                    styles.percentText,
                    period.available && styles.availableText,
                    {color: getCheckColor(period)},
                  ]}>
                  {period.percent}
                </Text>
                <Text
                  style={[
                    styles.codeText,
                    {color: getCheckColor(period), marginLeft: 3},
                    period.available && styles.availableText,
                  ]}>
                  ({period.breakTime}/{period.totalSession})
                </Text>
              </View>
            </View>
          </View>
        ))}
      </View>
    );
  };

  const renderSchedule = item => {
    if (!isShow) return null;
    return (
      <View style={styles.tableContainer}>
        {renderHeaderSchedule()}
        {scheduleData.map((dayData, index) => renderRow(dayData, index))}
      </View>
    );
  };

  const renderButton = () => {
    return (
      <View style={styles.btnRegister2}>
        <Button
          title={'Đăng kí dạy bù'}
          backgroundColor={R.colors.blue}
          textColor={R.colors.white}
          onPress={() => onSave(formData)}
          fontSize={R.sizes.sm}
          fontFamily={R.fonts.fontMedium}
          height={35}
          containerStyle={{paddingHorizontal: 15, borderRadius: 10}}
        />
      </View>
    );
  };

  const renderBody = () => {
    return (
      <ScrollView showsVerticalScrollIndicator={false}>
        <View style={styles.body}>
          {renderForm()}
          <ScrollView showsHorizontalScrollIndicator={false} horizontal>
            {renderSchedule()}
          </ScrollView>
          {renderButton()}
        </View>
      </ScrollView>
    );
  };
  return (
    <View style={styles.container}>
      <Header title={'Đăng kí báo bù'} isBack />
      {renderBody()}
    </View>
  );
};

export default CompensateRegisterView;
