import {StyleSheet, Text, View, Platform} from 'react-native';
import R from '../../../../assets/R';
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
  },

  // Card styles
  cardWithMargin: {
    marginHorizontal: 15,
    marginTop: 10,
    borderRadius: 10,
  },
  containerCard: {
    marginHorizontal: 15,
    borderRadius: 10,
  },
  card: {
    borderBottomEndRadius: 10,
    borderBottomStartRadius: 10,
    paddingHorizontal: 10,
    paddingVertical: 5,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 2,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },

  // Container styles for text rows
  containerText: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    marginBottom: 5,
  },
  containerTextItemLeft: {
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    width: '45%',
  },
  containerTextItemRight: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  sizedBox: {
    flex: 3,
  },
  containerSubText: {
    flexDirection: 'row',
    marginBottom: 5,
  },
  containerSubTextItemLeft: {},
  containerSubTextItemRight: {},

  // Text styles
  text: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
    textAlign: 'center',
  },
  regularText: {
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  textTitle: {
    fontSize: R.sizes.md,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.blue,
    marginHorizontal: 15,
  },
  textTitleWithMargin: {
    marginVertical: 10,
  },

  // Status header styles
  statusHeaderText: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.white,
    marginHorizontal: 10,
    marginVertical: 3,
  },
  statusText: {
    color: R.colors.white,
  },

  // History card text styles
  historyCardText: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },

  // Checkbox styles
  checkboxContainer: {
    flexDirection: 'row',
    flexWrap: 'wrap',
    justifyContent: 'space-between',
  },
  checkboxItem: {
    width: '50%',
    marginBottom: 15,
  },
  label: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  imageStyle: {},
});

export default styles;
