import React, {useState} from 'react';
import ModalRequestReportView from './view';

const ModalRequestReport = props => {
  const {visible, onClose, onSubmitReport, workData} = props;

  const [reportTitle, setReportTitle] = useState('');
  const [reportContent, setReportContent] = useState('');
  const [reportDeadline, setReportDeadline] = useState('');

  const handleSubmit = () => {
    if (!reportTitle.trim()) {
      alert('Vui lòng nhập tiêu đề báo cáo');
      return;
    }
    if (!reportContent.trim()) {
      alert('Vui lòng nhập nội dung yêu cầu');
      return;
    }
    if (!reportDeadline.trim()) {
      alert('Vui lòng nhập hạn báo cáo');
      return;
    }

    const reportData = {
      title: reportTitle.trim(),
      content: reportContent.trim(),
      deadline: reportDeadline.trim(),
      workId: workData?.id,
      implementers: workData?.implementer || [],
    };

    onSubmitReport(reportData);

    resetForm();
  };

  const resetForm = () => {
    setReportTitle('');
    setReportContent('');
    setReportDeadline('');
  };

  const handleClose = () => {
    resetForm();
    onClose();
  };

  return (
    <ModalRequestReportView
      visible={visible}
      onClose={handleClose}
      onSubmit={handleSubmit}
      reportTitle={reportTitle}
      setReportTitle={setReportTitle}
      reportContent={reportContent}
      setReportContent={setReportContent}
      reportDeadline={reportDeadline}
      setReportDeadline={setReportDeadline}
      implementers={workData?.implementer}
    />
  );
};

export default ModalRequestReport;
