import React from 'react';
import {Text, View, TouchableOpacity, StyleSheet, FlatList} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import {useNavigation} from '@react-navigation/native';
import {Image} from 'react-native';
import * as ScreenName from '../../routers/ScreenNames';
const ListRestReportView = props => {
  const {dataList} = props;
  const navigation = useNavigation();
  const renderItem = ({item}) => {
    return (
      <TouchableOpacity
        onPress={() => {
          navigation.navigate(ScreenName.ABSENCELISTBYCOURSE);
        }}
        style={styles.containerCard}>
        <View>
          <Text
            style={[
              styles.text,
              {
                fontWeight: '600',
                fontFamily: R.fonts.fontMedium,
                color: R.colors.blue,
              },
            ]}>
            Lớp: {item.classCode}
          </Text>
        </View>

        <View style={{alignItems: 'center'}}>
          <Text
            style={[
              styles.text,
              {fontWeight: '600', fontFamily: R.fonts.fontMedium},
            ]}>
            Nghỉ / Bù / Tổng
          </Text>
          <Text style={[styles.text]}>
            {item.rest} / {item.compensate} / {item.total}
          </Text>
        </View>

        <View style={styles.btnRight}>
          <Image
            source={R.images.icNext}
            style={{width: 15, height: 15}}
            resizeMode="contain"
            tintColor={R.colors.black}
          />
        </View>
      </TouchableOpacity>
    );
  };

  const renderCard = () => {
    return (
      <View style={styles.card}>
        <TouchableOpacity style={styles.btnCard}>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Học kỳ 2, Năm 2025
          </Text>
        </TouchableOpacity>
      </View>
    );
  };

  const renderList = () => {
    return (
      <FlatList
        data={dataList || []}
        renderItem={renderItem}
        showsVerticalScrollIndicator={false}
        vertical
        keyExtractor={(item, index) => `${index}`}
      />
    );
  };

  const renderButton = () => {
    return (
      <TouchableOpacity
        style={styles.btnRegister}
        onPress={() => navigation.navigate(ScreenName.REGISTERABSENCE)}>
        <Text style={[styles.text, {color: R.colors.white}]}>
          Đăng kí báo nghỉ
        </Text>
      </TouchableOpacity>
    );
  };

  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderCard()}
        {renderList()}
        {renderButton()}
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Báo nghỉ lịch dạy'} isBack />
      {renderBody()}
    </View>
  );
};

export default ListRestReportView;
