import React from 'react';
import {View, Text, TextInput} from 'react-native';
import {HEIGHTXD, WIDTHXD, getFontXD} from '../../config/Functions';
import R from '../../assets/R';

const TextField = ({
  title,
    titleFontSize = R.fontsize.fontSizeContent,
    required, 
    onChangeText, 
    maxLength,
    backgroundColor, 
    value, 
    editable,
    placeholder,
    fontSizePlaceHolder = R.fontsize.fontSizeContent,
    containerMarginVertical,
    containerMarginHorizontal,
    containerMarginBottom,
    containerMarginTop,
    containerBackgroundColor,
    onFocus,
    fontFamily = R.fonts.fontMedium,
    fontWeight = '600',
    height,
    color = R.colors.black,
    numberOfLines = 5,
    borderBottomWidth,
    paddingVertical =10,
    paddingHorizontal = 10,
}) => {
 
  return (
    <View style={{
      marginTop: containerMarginTop,
      marginVertical: containerMarginVertical, 
      marginHorizontal: containerMarginHorizontal, 
      marginBottom: containerMarginBottom , 
      backgroundColor: containerBackgroundColor}}>
      <Text
        style={{
          fontSize: titleFontSize,
          color: color,
          fontFamily:fontFamily,
          fontWeight:fontWeight,
          marginBottom: 5,
        }}>
        {title ? title : ''}
        <Text style={{color: R.colors.red}}> {required ? "*" : ""}</Text>
      </Text>
      <TextInput
        placeholder={placeholder}
        maxLength={maxLength}
        textAlign={'left'}
        editable={editable != null ? editable : true}
        value={value}
        onChangeText={val => onChangeText(val)}
        multiline={true}
        numberOfLines={numberOfLines}
        onFocus={onFocus}
           placeholderTextColor= {
          editable === false 
      ? (backgroundColor || R.colors.black) // khi disabled thì lấy màu xám
      : backgroundColor || R.colors.gray        }
        autoCapitalize="none"
        style={{
          textAlignVertical: 'top',
          textAlign: 'left',
          color: 'black',
          height: height,
          borderColor:R.colors.grayBorderInputTextHeader,
          borderWidth:1,
          borderBottomWidth:borderBottomWidth,
          width: '100%',
          borderRadius: 7,
          fontSize: fontSizePlaceHolder,
          paddingVertical: paddingVertical,
          paddingHorizontal: paddingHorizontal,
            backgroundColor:  editable === false 
      ? (backgroundColor || R.colors.blue1) // khi disabled thì lấy màu xám
      : backgroundColor, // khi enable thì lấy màu bạn truyền,
        }}
      />
    </View>
  );
};

export default React.memo(TextField);
