import React from 'react';
import { StyleSheet, Text, View, Image, TouchableOpacity } from 'react-native';
import { Camera } from 'react-native-vision-camera';

const CameraScreen = ({
  avatarUri,
  openCamera,                 // () => void
  showCamera,                 // boolean
  cameraRef,                  // React.RefObject<Camera>
  device,                     // CameraDevice | undefined
  onToggleCameraPosition,     // () => void  (thay cho setUseFront)
  onTakePhoto,                // () => void
  onCloseCamera,              // () => void  (thay cho setShowCamera(false))
}) => {
  return (
    <View style={{ flex: 1 }}>
      {/* Avatar */}
      <View style={{ alignItems: 'center', marginTop: 16 }}>
        {avatarUri ? (
          <Image source={{ uri: avatarUri }} style={{ width: 120, height: 120, borderRadius: 60 }} />
        ) : (
          <View style={{ width: 120, height: 120, borderRadius: 60, backgroundColor: '#eee' }} />
        )}
        <TouchableOpacity onPress={openCamera} style={styles.pickBtn}>
          <Text style={styles.pickBtnText}>Chọn ảnh</Text>
        </TouchableOpacity>
      </View>

      {/* Overlay Camera */}
      {showCamera && (
        <View style={styles.overlay}>
          {device ? (
            <>
              <Camera
                ref={cameraRef}
                style={StyleSheet.absoluteFill}
                device={device}
                isActive={showCamera}
                photo  // cần để dùng takePhoto()
              />
              <View style={styles.controls}>
                <TouchableOpacity style={styles.smallBtn} onPress={onToggleCameraPosition}>
                  <Text style={styles.btnText}>Đổi cam</Text>
                </TouchableOpacity>

                <TouchableOpacity style={styles.shutter} onPress={onTakePhoto} />

                <TouchableOpacity style={styles.smallBtn} onPress={onCloseCamera}>
                  <Text style={styles.btnText}>Đóng</Text>
                </TouchableOpacity>
              </View>
            </>
          ) : (
            <View style={[styles.overlay, styles.center]}>
              <Text style={{ color: '#fff' }}>Không tìm thấy camera</Text>
              <TouchableOpacity style={[styles.smallBtn, { marginTop: 16 }]} onPress={onCloseCamera}>
                <Text style={styles.btnText}>Đóng</Text>
              </TouchableOpacity>
            </View>
          )}
        </View>
      )}
    </View>
  );
};

export default CameraScreen;

const styles = StyleSheet.create({
  overlay: {
    position: 'absolute', top: 0, left: 0, right: 0, bottom: 0,
    backgroundColor: 'black',
  },
  controls: {
    position: 'absolute', bottom: 30, left: 0, right: 0,
    flexDirection: 'row', justifyContent: 'space-around', alignItems: 'center',
  },
  shutter: {
    width: 68, height: 68, borderRadius: 34,
    borderWidth: 4, borderColor: '#fff',
    backgroundColor: 'rgba(255,255,255,0.2)',
  },
  smallBtn: {
    paddingHorizontal: 12, paddingVertical: 8,
    borderRadius: 8, backgroundColor: 'rgba(255,255,255,0.2)',
  },
  btnText: { color: '#fff', fontWeight: '600' },
  pickBtn: {
    marginTop: 12, padding: 8, backgroundColor: '#2e6ef7', borderRadius: 8,
  },
  pickBtnText: { color: '#fff', fontWeight: '600' },
  center: { justifyContent: 'center', alignItems: 'center' },
});
