import {StyleSheet, Platform} from 'react-native';
import R from '../../assets/R';
const styles = StyleSheet.create({
  safeArea: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  //TabView
  tabButtonItem: {
    paddingHorizontal: Platform.OS === 'ios' ? 10 : 5,
    paddingVertical: Platform.OS === 'ios' ? 5 : 2,
    minWidth: Platform.OS === 'ios' ? 70 : 80,
    backgroundColor: R.colors.grayButton,
    borderRadius: 10,
    height:35,
    marginRight: Platform.OS === 'ios' ? 23 : 15,
    alignItems: 'center',
    justifyContent: 'center',
  },
  tabButtonActiveItem: {
    backgroundColor: R.colors.blue,
    color: R.colors.white,
  },
  tabButtonContainer: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
    marginHorizontal: 15,
    marginVertical: 10,
  },
  textTabView: {
    color: R.colors.white,
    fontSize: R.sizes.sm,
    fontWeight: '500',
    fontFamily: R.fonts.fontSemiBold,
  },
  containerBody: {
    flex: 1,
    justifyContent: 'center',
  },
  //InputText
  containerSearchBox: {
    borderColor: R.colors.grayBorderInputTextHeader,
    borderWidth: 1,
    borderRadius: 100,
    marginHorizontal: 15,
    marginBottom:10,
    backgroundColor: R.colors.white,
    flexDirection: 'row',
    height: 35,
  },
  boxIconSearch: {
    maxWidth: 35,
    maxHeight: 35,
    alignItems: 'center',
    justifyContent: 'center',
    marginHorizontal: Platform.OS === 'ios' ? 5 : 10,
  },
  inputSearch: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '500',
    flex: 1,
    padding: 0,
  },

  // boxSearch:{
  //     position:'relative',
  //     top:0,
  //     right:0,
  //     left:0,
  // },
  //List Notification
  containerListNotification: {
    paddingVertical: 15,
  },
  cardItem: {
    paddingVertical: 5,
    paddingHorizontal: 15,
    marginVertical:7.5,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    marginHorizontal: 15,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 2,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  cardItemTution: {
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  boxLeft: {
    flex: 1,
  },
  boxRight: {
    justifyContent: 'center',
    alignItems: 'center',
  },
  containerEmpty: {
    alignItems: 'center',
    justifyContent: 'center',
  },
  text: {
    fontSize: R.sizes.sm,
    fontWeight: '400',
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
  },
  textEmpty: {
    color: R.colors.black,
    fontSize: R.fontsize.fontSizeSubTitle,
    fontWeight: '500',
    fontFamily: R.fonts.fontMedium,
  },
  boxTimeTution: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    flex: 1,
  },
  sizedBox: {
    width: '10%',
  },
  boxTimeView: {
    alignItems: 'flex-end',
  },
  btnFooter: {
    backgroundColor: R.colors.blue,
    paddingHorizontal: 20,
    borderRadius: 10,
    alignItems: 'center',
    justifyContent: 'center',
    marginHorizontal: 15,
    marginBottom: 10,
    height: 35,
  },
  textBtnFooter: {
    color: R.colors.white,
    fontSize: R.sizes.sm,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
  },
});
export default styles;
