import React, {useState, useEffect} from 'react';
import EditReportModalView from './view';

const EditReportModal = ({visible, onClose, onSubmit, initialContent = ''}) => {
  const [reportContent, setReportContent] = useState(initialContent);

  // Update reportContent when initialContent changes
  useEffect(() => {
    setReportContent(initialContent);
  }, [initialContent]);

  const handleSubmit = () => {
    if (reportContent.trim()) {
      onSubmit(reportContent);
      onClose();
    }
  };

  const handleCancel = () => {
    setReportContent(initialContent);
    onClose();
  };

  const handleContentChange = (content) => {
    setReportContent(content);
  };

  const handleDeleteAttachment = () => {
    // Handle attachment deletion logic
    console.log('Delete attachment');
  };

  const handleAddAttachment = () => {
    // Handle add attachment logic
    console.log('Add attachment');
  };

  return (
    <EditReportModalView
      visible={visible}
      onClose={onClose}
      reportContent={reportContent}
      onContentChange={handleContentChange}
      onSubmit={handleSubmit}
      onCancel={handleCancel}
      onDeleteAttachment={handleDeleteAttachment}
      onAddAttachment={handleAddAttachment}
    />
  );
};

export default EditReportModal;
