import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  FlatList,
  Image,
  TextInput,
  LogBox,
} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import * as ScreenName from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
import Button from '../../components/Button';
import Dropdown from '../../components/DropdownAlert/Dropdown';
import FAB from '../../components/FAB/fab';
import SubButton from '../../components/FAB/sub_button';
const ListSendView = props => {
  const {
    activeTab,
    dataListTabView,
    dataList,
    searchQuery,
    setSearchQuery,
    handleTabKey,
  } = props;
  const navigation = useNavigation();
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const getColorStatus = status => {
    switch (status) {
      case 'Chờ xét duyệt':
        return R.colors.blue;
      case 'Cần chỉnh sửa':
        return R.colors.orange;
      case 'Đã phê duyệt':
        return R.colors.green;
      case 'Dự thảo':
        return R.colors.orange;
    }
  };
  const getColorRegime = regime => {
    switch (regime) {
      case 'Hạn chế':
        return R.colors.brown;
      case 'Công khai':
        return R.colors.blue;
    }
  };

  const hasRelatedWork = n => Number(n) > 0;
  const getHiddenButton = n => (hasRelatedWork(n) ? true : false);

  const itemTabView = ({item, index}) => {
    const isActive = item.key === activeTab;
    return (
      <TouchableOpacity
        style={[styles.itemTabView, isActive ? styles.activeTab : null]}
        onPress={() => handleTabKey && handleTabKey(item.key)}>
        <Text
          style={[styles.textTabView, isActive ? styles.activeTabText : null]}>
          {item.title_status}
        </Text>
      </TouchableOpacity>
    );
  };

  const renderItemIncomingDocument = ({item}) => {
    const showRelatedWork = getHiddenButton(item?.total_head_of_work);
    return (
      <View style={styles.cardIncomingDocument}>
        <Text style={styles.textSubTitle}>{item.title}</Text>

        <View style={{flexDirection: 'row', justifyContent: 'space-between'}}>
          <Text style={styles.textSubTitle}>
            Ngày tạo: <Text style={styles.text}>{item.term}</Text>
          </Text>
          <Text style={styles.textSubTitle}>
            Trạng thái:{' '}
            <Text style={[{color: getColorStatus(item.status)}]}>
              {item.status}
            </Text>
          </Text>
        </View>
        <Text style={styles.textSubTitle}>
          Chế độ:{' '}
          <Text style={[{color: getColorRegime(item.regime)}]}>
            {item.regime}
          </Text>
        </Text>

        <View
          style={{
            flexDirection: 'row',
            alignSelf: 'flex-end',
            marginVertical: 5,
          }}>
          {showRelatedWork && (
            <Button
              title="Công việc"
              onPress={() => {}}
              backgroundColor={R.colors.orange}
              textColor={R.colors.white}
              height={25}
              borderRadius={15}
              fontSize={11}
              fontWeight={'600'}
              fontFamily={R.fonts.fontMedium}
              paddingHorizontal={15}
            />
          )}

          {item.status === 'Cần chỉnh sửa' && (
            <>
              <View style={{flex: 0.1}}></View>
              <Button
                title="Chỉnh sửa"
                onPress={() => navigation.navigate(ScreenName.EDITSENDDOCUMENT)}
                backgroundColor={R.colors.orange}
                textColor={R.colors.white}
                width={150}
                height={30}
                borderRadius={15}
                fontSize={R.sizes.sm}
                fontWeight={'600'}
                fontFamily={R.fonts.fontMedium}
                paddingHorizontal={15}
              />
            </>
          )}

          {item.status === 'Dự thảo' && (
            <>
              <View style={{flex: 0.1}}></View>
              <Button
                title="Yêu cầu phê duyệt"
                onPress={() =>
                  navigation.navigate(ScreenName.STATUSSENDDOCUMENT)
                }
                backgroundColor={R.colors.orange}
                textColor={R.colors.white}
                height={30}
                width={160}
                borderRadius={15}
                fontSize={R.sizes.sm}
                fontWeight={'600'}
                fontFamily={R.fonts.fontMedium}
                paddingHorizontal={15}
              />
            </>
          )}

          <View style={{flex: 0.1}}></View>
          <Button
            title="Chi tiết"
            onPress={() => navigation.navigate(ScreenName.DETAILSENDDOCUMENT)}
            backgroundColor={R.colors.blue}
            textColor={R.colors.white}
            height={30}
            width={90}
            borderRadius={15}
            fontSize={R.sizes.sm}
            fontWeight={'600'}
            fontFamily={R.fonts.fontMedium}
            paddingHorizontal={15}
          />
        </View>
      </View>
    );
  };

  const renderListIncomingDocument = () => {
    return (
      <FlatList
        data={dataList}
        renderItem={renderItemIncomingDocument}
        keyExtractor={item => item.id.toString()}
        showsVerticalScrollIndicator={false}
      />
    );
  };

  const renderListView = () => {
    return (
      <View style={styles.cardTabView}>
        <FlatList
          data={dataListTabView}
          renderItem={itemTabView}
          keyExtractor={item => item.key}
          horizontal
          contentContainerStyle={styles.contentContainerStyle}
          showsHorizontalScrollIndicator={false}
        />
      </View>
    );
  };

  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderListView()}

        {renderCard()}

        {renderListIncomingDocument()}
      </View>
    );
  };
  const renderFilter = () =>{
    return (
      
        <View style={styles.box_3}>
          <View style={styles.searchBox}>
            <Image source={R.images.icSearch} style={{width: 20, height: 20}} />
            <View style={{flex: 1}}>
              <TextInput
                placeholder="Tìm kiếm"
                style={[styles.text, {padding: 0}]}
                value={searchQuery}
                onChangeText={setSearchQuery}
              />
            </View>
          </View>
          <View style={{flex: 0.1}}></View>

          <View style={styles.boxFilter}>
            <Dropdown title={'Tìm kiếm'} height={35} />
          </View>
        </View>
    )
  }

  const renderCard = () => {
    return (
      <View >
        <View style={styles.card}>
          <TouchableOpacity style={styles.btnCard}>
            <Text
              style={[
                styles.text,
                {
                  fontSize: R.fontsize.fontSizeContent,
                  fontWeight: '600',
                  fontFamily: R.fonts.fontMedium,
                  color: R.colors.black,
                },
              ]}>
              Học kỳ 2, Năm 2025
            </Text>
          </TouchableOpacity>
        </View>
            {renderFilter()}
      </View>
    );
  };
  return (
    <View style={styles.container}>
      <Header title={'Danh sách văn bản đi'} isBack />
      <View style={{flex: 1}}>
        {renderBody()}

        <View style={{marginHorizontal: 15}}>
          <FAB>
            <SubButton
              onPress={() => navigation.navigate(ScreenName.ADDSENDOCUMENT)}
              label="Soạn văn bản đi"
              images={R.images.icEdit}
              backgroundColor={R.colors.orange}
            />
          </FAB>
        </View>
      </View>
    </View>
  );
};

export default ListSendView;
