import {StyleSheet, Dimensions} from 'react-native';
import R from '../../assets/R';

const {width: screenWidth, height: screenHeight} = Dimensions.get('window');
const CELL_WIDTH = (screenWidth - 30) / 7;
const CELL_HEIGHT = (screenHeight - 160) / 6;
const BOTTOM_SHEET_HEIGHT = screenHeight * 0.6;

const styles = StyleSheet.create({
  // Container chính của màn hình
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
    alignItems: 'center',
  },

  // Header tháng/năm với nút điều hướng
  header: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingVertical: 15,
  },
  header_title: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    fontWeight: '600',
  },
  // Nút điều hướng tháng trước/sau
  navButton: {
    width: 30,
    height: 30,
    borderRadius: 20,
    backgroundColor: R.colors.blue,
    alignItems: 'center',
    justifyContent: 'center',
  },
  navButtonText: {
    color: R.colors.white,
    fontSize: R.fontsize.fontsSizeTitle,
    fontFamily: R.fonts.fontMedium,
    height: '100%',
  },

  // Tiêu đề các ngày trong tuần
  weekDaysContainer: {
    flexDirection: 'row',
    paddingBottom: 5,
    marginBottom: 5,
  },
  weekDayCell: {
    width: CELL_WIDTH,
    alignItems: 'center',
  },
  weekDayText: {
    fontFamily: R.fonts.fontMedium,
    fontSize: R.fontsize.fontSizeLabel,
    fontWeight: '600',
    color: R.colors.black,
  },

  // Lưới lịch
  calendarGrid: {},
  weekRow: {
    flexDirection: 'row',
  },

  // Ô ngày trong lịch
  dayCell: {
    width: CELL_WIDTH,
    minHeight: CELL_HEIGHT,
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    padding: 6,
    alignItems: 'center',
  },
  // Ô ngày được chọn
  selectedDayCell: {
    borderColor: R.colors.blue,
    borderWidth: 1,
  },
  // Text số ngày
  dayText: {
    fontSize: R.fontsize.fontSizeLabel,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
    marginBottom: 2,
  },
  // Text ngày không thuộc tháng hiện tại
  dayTextInactive: {
    color: R.colors.black,
    opacity: 1,
  },
  // Text ngày được chọn
  selectedDayText: {
    color: R.colors.black,
    fontWeight: '500',
    fontFamily: R.fonts.fontSemiBold,
  },
  // Text ngày hôm nay
  todayText: {
    color: R.colors.white,
    fontWeight: 'bold',
    fontFamily: R.fonts.fontSemiBold,
    backgroundColor: R.colors.blue,
    borderRadius: 15,
    paddingHorizontal: 6,
    paddingVertical: 4,
  },

  // Sự kiện trong ô ngày
  eventsContainer: {
    width: '100%',
    flex: 1,
  },
  // Thanh sự kiện nhỏ trong ô ngày
  eventBar: {
    paddingVertical: 2,
    paddingHorizontal: 5,
    borderRadius: 10,
    marginBottom: 2,
    backgroundColor: R.colors.blue,
  },
  eventBarText: {
    fontSize: R.fontsize.fontSizeLabel,
    color: R.colors.white,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
  },
  // Text hiển thị số sự kiện còn lại
  moreEventsText: {
    fontSize: R.fontsize.fontSizeLabel,
    color: R.colors.gray,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    textAlign: 'center',
  },

  // Modal bottom sheet
  modalBackdrop: {
    flex: 1,
    backgroundColor: R.colors.grayBorderInputTextHeader,
    justifyContent: 'flex-end',
  },
  bottomSheet: {
    height: BOTTOM_SHEET_HEIGHT,
    backgroundColor: R.colors.white,
    borderTopLeftRadius: 20,
    borderTopRightRadius: 20,
  },

  // Nội dung bottom sheet
  bottomSheetContent: {
    height: BOTTOM_SHEET_HEIGHT,
  },
  // Thanh kéo
  dragHandle: {
    width: 40,
    height: 4,
    backgroundColor: R.colors.gray,
    borderRadius: 5,
    alignSelf: 'center',
    marginTop: 10,
    marginBottom: 15,
  },
  // Header của bottom sheet
  bottomSheetHeader: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 15,
  },
  bottomSheetTitle: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    fontWeight: '600',
    flex: 1,
  },
  // Nút đóng bottom sheet
  closeButton: {
    width: 30,
    height: 30,
    borderRadius: 15,
    backgroundColor: R.colors.gray,
    alignItems: 'center',
    justifyContent: 'center',
  },
  closeButtonText: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },

  // Danh sách sự kiện trong bottom sheet
  // ScrollView chứa danh sách sự kiện
  eventsScrollView: {
    paddingTop: 10,
  },
  // Container cho từng sự kiện
  containerBottomSheet: {
    flex: 1,
    marginBottom: 10,
  },
  // Trạng thái không có sự kiện
  noEventsContainer: {
    flex: 1,
    alignItems: 'center',
    justifyContent: 'center',
    paddingVertical: 40,
  },
  noEventsText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.gray,
    fontWeight: '400',
  },

  // Card sự kiện chi tiết
  eventCard: {
    flexDirection: 'row',
    backgroundColor: R.colors.white,
    borderRadius: 12,
    padding: 15,
    marginBottom: 10,
    marginHorizontal: 15,
    borderLeftWidth: 4,
    borderLeftColor: R.colors.blue,
    shadowColor: R.colors.black,
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 1,
    shadowRadius: 1,
    elevation: 2,
  },
  // Container thời gian sự kiện
  eventTimeContainer: {
    minWidth: 80,
    alignItems: 'flex-start',
    justifyContent: 'flex-start',
    marginRight: 15,
  },
  eventTime: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.blue,
    fontWeight: '600',
  },
  // Container nội dung sự kiện
  eventContent: {
    flex: 1,
  },
  eventTitle: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    fontWeight: '600',
    marginBottom: 4,
  },
  eventDescription: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.gray2,
    fontWeight: '400',
  },
});

export {styles, CELL_WIDTH, BOTTOM_SHEET_HEIGHT};
