import React, {useMemo, useState} from 'react';
import ListStudentView from './view';

const ListStudent = props => {
  const [searchText, setSearchText] = useState('');
  const handleSearchChange = text => {
    setSearchText(text);
  };

  const [dataListStudent, setDataListStudent] = useState([
    {
      id: '1',
      name: 'Nguyễn Minh Đức',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259101',
      date_student: '23/10/2004',
      tele_phone: '0987654321',
    },
    {
      id: '2',
      name: 'Bùi Thanh Ngọc',
      status: 'Cảnh cáo',
      gender: 'Nữ',
      code_student: '259102',
      date_student: '12/03/2005',
      tele_phone: '0978123456',
    },
    {
      id: '3',
      name: 'Trần Văn Hùng',
      status: 'Thôi học',
      gender: 'Nam',
      code_student: '259103',
      date_student: '05/08/2004',
      tele_phone: '0912345678',
    },
    {
      id: '4',
      name: 'Phạm Thị Hòa',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259104',
      date_student: '19/11/2004',
      tele_phone: '0908765432',
    },
    {
      id: '5',
      name: 'Lê Văn Nam',
      status: 'Cảnh cáo',
      gender: 'Nam',
      code_student: '259105',
      date_student: '01/01/2005',
      tele_phone: '0981112233',
    },
    {
      id: '6',
      name: 'Đặng Thị Mai',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259106',
      date_student: '14/02/2005',
      tele_phone: '0934567890',
    },
    {
      id: '7',
      name: 'Ngô Văn Sơn',
      status: 'Thôi học',
      gender: 'Nam',
      code_student: '259107',
      date_student: '29/06/2004',
      tele_phone: '0923456789',
    },
    {
      id: '8',
      name: 'Hoàng Thị Lan',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259108',
      date_student: '08/09/2005',
      tele_phone: '0919876543',
    },
    {
      id: '9',
      name: 'Nguyễn Văn Tài',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259109',
      date_student: '17/07/2004',
      tele_phone: '0909123456',
    },
    {
      id: '10',
      name: 'Trịnh Thị Hồng',
      status: 'Cảnh cáo',
      gender: 'Nữ',
      code_student: '259110',
      date_student: '24/04/2005',
      tele_phone: '0965432109',
    },
    {
      id: '11',
      name: 'Vũ Minh Quân',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259111',
      date_student: '12/12/2004',
      tele_phone: '0912233445',
    },
    {
      id: '12',
      name: 'Phan Thanh Tùng',
      status: 'Thôi học',
      gender: 'Nam',
      code_student: '259112',
      date_student: '06/03/2005',
      tele_phone: '0945566778',
    },
    {
      id: '13',
      name: 'Nguyễn Thị Kim',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259113',
      date_student: '22/05/2004',
      tele_phone: '0906677889',
    },
    {
      id: '14',
      name: 'Đỗ Văn Hào',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259114',
      date_student: '15/08/2005',
      tele_phone: '0978899001',
    },
    {
      id: '15',
      name: 'Nguyễn Thu Hằng',
      status: 'Cảnh cáo',
      gender: 'Nữ',
      code_student: '259115',
      date_student: '10/10/2004',
      tele_phone: '0983456789',
    },
    {
      id: '16',
      name: 'Trần Quốc Anh',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259116',
      date_student: '27/02/2005',
      tele_phone: '0914455667',
    },
    {
      id: '17',
      name: 'Hoàng Đức Thịnh',
      status: 'Thôi học',
      gender: 'Nam',
      code_student: '259117',
      date_student: '30/06/2004',
      tele_phone: '0933344556',
    },
    {
      id: '18',
      name: 'Phạm Mỹ Duyên',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259118',
      date_student: '02/09/2005',
      tele_phone: '0921234567',
    },
    {
      id: '19',
      name: 'Nguyễn Văn Kiên',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259119',
      date_student: '14/11/2004',
      tele_phone: '0977778888',
    },
    {
      id: '20',
      name: 'Trần Ngọc Ánh',
      status: 'Cảnh cáo',
      gender: 'Nữ',
      code_student: '259120',
      date_student: '25/07/2005',
      tele_phone: '0911222333',
    },
    {
      id: '21',
      name: 'Ngô Văn Lâm',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259121',
      date_student: '07/04/2005',
      tele_phone: '0903344556',
    },
    {
      id: '22',
      name: 'Lưu Thị Thu',
      status: 'Thôi học',
      gender: 'Nữ',
      code_student: '259122',
      date_student: '19/06/2004',
      tele_phone: '0988776655',
    },
    {
      id: '23',
      name: 'Phạm Văn Toàn',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259123',
      date_student: '28/08/2005',
      tele_phone: '0929988776',
    },
    {
      id: '24',
      name: 'Nguyễn Thị Yến',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259124',
      date_student: '13/01/2005',
      tele_phone: '0910099887',
    },
    {
      id: '25',
      name: 'Trần Minh Hiếu',
      status: 'Cảnh cáo',
      gender: 'Nam',
      code_student: '259125',
      date_student: '04/05/2004',
      tele_phone: '0961122334',
    },
    {
      id: '26',
      name: 'Vũ Thị Mai',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259126',
      date_student: '16/02/2005',
      tele_phone: '0932211334',
    },
    {
      id: '27',
      name: 'Nguyễn Văn Phúc',
      status: 'Thôi học',
      gender: 'Nam',
      code_student: '259127',
      date_student: '09/12/2004',
      tele_phone: '0907788990',
    },
    {
      id: '28',
      name: 'Bùi Thanh Tâm',
      status: 'Đang học',
      gender: 'Nam',
      code_student: '259128',
      date_student: '18/03/2005',
      tele_phone: '0914455778',
    },
    {
      id: '29',
      name: 'Lê Thị Trang',
      status: 'Đang học',
      gender: 'Nữ',
      code_student: '259129',
      date_student: '06/06/2005',
      tele_phone: '0925566778',
    },
    {
      id: '30',
      name: 'Nguyễn Khánh Duy',
      status: 'Cảnh cáo',
      gender: 'Nam',
      code_student: '259130',
      date_student: '21/09/2004',
      tele_phone: '0978899221',
    },
  ]);

  const filterData = dataListStudent.filter(item =>{
    const matchSearch = item.name.toLowerCase().includes(searchText.toLowerCase());
    return matchSearch;
  })

  const getStatusColor = status => {
    const statusColor = {
      'Đang học': '#4CAF50',
      'Cảnh cáo': '#FFC107',
      'Thôi học': '#F44336',
    };
    return statusColor[status] || '#9E9E9E';
  };
  const statusStats = useMemo(() => {
    const stats = dataListStudent.reduce((acc, student) => {
      acc[student.status] = (acc[student.status] || 0) + 1;
      return acc;
    }, {});

    return Object.entries(stats).map(([status, count]) => ({
      status,
      count,
      color: getStatusColor(status),
    }));
  }, [dataListStudent]);

  return (
    <ListStudentView
      searchText={searchText}
      onSearchChange={handleSearchChange}
      dataListStudent={filterData}
      statusStats={statusStats}
    />
  );
};

export default ListStudent;
