import {Dimensions, StyleSheet, Text, View} from 'react-native';
import React from 'react';
import R from '../../../assets/R';
const {width, height} = Dimensions.get('window');
const FIRST_COLUMN = 80;
const NAME_COLUMN = 180;
const DATE_COLUMN = 100;
const STATUS_COLUMN = 100;
const NOTE_COLUMN = 350;

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    paddingHorizontal: 15,
    marginBottom: 15,
  },
  textTitle: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.blue,
    marginBottom: 10,
  },
  tableContainer: {
    flex: 1,
    borderWidth: 1,
    borderColor: R.colors.gray3,
  },
  tableWrapper: {
    minWidth:
      FIRST_COLUMN + NAME_COLUMN + DATE_COLUMN + STATUS_COLUMN + NOTE_COLUMN,
  },
  tableHeader: {
    flexDirection: 'row',
    backgroundColor: R.colors.blue2,
    height: 50,
  },
  headerCell: {
    height: 50,
    paddingVertical: 10,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray3,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray3,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.blue2,
  },
  headerText: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
    textAlign: 'center',
  },
  tableRow: {
    flexDirection: 'row',
    alignItems: 'center',
    height: 60,
  },
  tableCell: {
    height: 60,
    paddingVertical: 10,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray3,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray3,
    justifyContent: 'center',
    alignItems: 'center',
  },
  cellText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
    textAlign: 'center',
  },
  codeColumn: {
    width: FIRST_COLUMN,
  },
  nameColumn: {
    width: NAME_COLUMN,
    textAlign: 'left',
  },
  dateColumn: {
    width: DATE_COLUMN,
  },
  statusColumn: {
    width: STATUS_COLUMN,
  },
  noteColumn: {
    width: NOTE_COLUMN,
    fontSize: R.fontsize.fontSizeContent,
  },
  statusContainer: {
    alignItems: 'center',
    justifyContent: 'center',
  },
  statusText: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    textAlign: 'center',
  },
  noteInput: {
    width: '100%',
    minHeight: 40,
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
    textAlign: 'left',
    paddingHorizontal: 8,
    paddingVertical: 4,
  },
  textTitleStatus: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
  },
});

export default styles;
