import React, {useEffect, useState} from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  ScrollView,
  FlatList,
} from 'react-native';
import R from '../../../assets/R';
import styles from './style';
import Header from '../../../components/Header/Header';
import TextMulti from '../../../components/Input/TextMulti';
import TextField from '../../../components/Input/TextField';
import Dropdown from '../../../components/DropdownAlert/Dropdown';

const ApprovalView = props => {
  const {icomingDocument, item, dataList} = props;
  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity style={styles.containerIcon} onPress={onPress}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };

  const body = () => {
    return (
      <ScrollView showsVerticalScrollIndicator={false}>
        <View style={styles.body}>
          <View style={styles.row_1}>
            <Text style={styles.sub_text}>
              Ngày tạo: <Text style={styles.sub_text}>29/07/2025</Text>
            </Text>
            <Text style={styles.sub_text}>
              Trạng thái:{' '}
              <Text style={[styles.sub_text, {color: R.colors.blue}]}>
                Chờ phê duyệt
              </Text>
            </Text>
          </View>
          <TextField
            title="Tiêu đề"
            required
            fontSize={R.fontsize.fontSizeContent}
            fontSizeTitle={R.fontsize.fontSizeContent}
            fontFamily={R.fonts.fontSemiBold}
            placeholder="Nhập tiêu đề"
            containerMarginBottom={10}
            editable={false}
          />
          <TextMulti
            title="Nội dung văn bản"
            required
            fontSize={R.fontsize.fontSizeContent}
            titleFontSize={R.fontsize.fontSizeContent}
            fontFamily={R.fonts.fontSemiBold}
            placeholder="Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan"
            containerMarginBottom={10}
            numberOfLines={3}
            editable={false}
          />
          <TextMulti
            title="Ghi chú"
            fontSize={R.fontsize.fontSizeContent}
            titleFontSize={R.fontsize.fontSizeContent}
            fontFamily={R.fonts.fontSemiBold}
            placeholder="Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan"
            containerMarginBottom={10}
            numberOfLines={3}
            editable={false}
          />
          <TextField
            fontSize={R.fontsize.fontSizeContent}
            titleFontSize={R.fontsize.fontSizeContent}
            fontFamily={R.fonts.fontSemiBold}
            title="Loại văn bản"
            required
            editable={false}
            containerMarginBottom={10}
          />
          <TextField
            title="Loại vực văn bản"
            required
            editable={false}
            containerMarginBottom={10}
          />

          <View style={styles.containerDropdown}>
            <Text style={[{marginBottom: 3}, styles.sub_text]}>
              Chế độ <Text style={{color: R.colors.red}}>*</Text>
            </Text>
            <Dropdown
              required
              containerMarginBottom={10}
              height={35}
              editable={false}
            />
          </View>

          <View style={styles.containerDropdown}>
            <Text style={[{marginBottom: 3}, styles.sub_text]}>
              Phòng ban nhận <Text style={{color: R.colors.red}}>*</Text>
            </Text>
            <Dropdown
              required
              containerMarginBottom={10}
              height={35}
              editable={false}
            />
          </View>
          <Text style={[{marginBottom: 3}, styles.sub_text]}>
            Danh sách phòng ban nhận đã chọn :
          </Text>
          <FlatList
            data={dataList}
            renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
            keyExtractor={(item, index) =>
              item.id?.toString() || index.toString()
            }
            numColumns={2}
            style={{maxHeight: 150, marginBottom: 10}}
            showsVerticalScrollIndicator={true}
            columnWrapperStyle={styles.flatListSelect}
            nestedScrollEnabled={true}
            scrollEnabled={true}
          />

          <View style={styles.containerDropdown}>
            <Text style={[{marginBottom: 3}, styles.sub_text]}>
              Nhóm người nhận <Text style={{color: R.colors.red}}>*</Text>
            </Text>
            <Dropdown
              required
              containerMarginBottom={10}
              height={35}
              editable={false}
            />
          </View>
          <Text style={[{marginBottom: 3}, styles.sub_text]}>
            Danh sách nhóm người nhận đã chọn :
          </Text>
          <FlatList
            data={dataList}
            renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
            keyExtractor={(item, index) =>
              item.id?.toString() || index.toString()
            }
            numColumns={2}
            style={{maxHeight: 150, marginBottom: 10}}
            showsVerticalScrollIndicator={true}
            columnWrapperStyle={styles.flatListSelect}
            nestedScrollEnabled={true}
            scrollEnabled={true}
          />

          <View style={styles.containerDropdown}>
            <Text style={[{marginBottom: 3}, styles.sub_text]}>
              Người nhận <Text style={{color: R.colors.red}}>*</Text>
            </Text>
            <Dropdown
              editable={false}
              required
              containerMarginBottom={10}
              height={35}
            />
          </View>
          <Text style={[{marginBottom: 3}, styles.sub_text]}>
            Danh sách người nhận đã chọn :
          </Text>
          <FlatList
            data={dataList}
            renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
            keyExtractor={(item, index) =>
              item.id?.toString() || index.toString()
            }
            numColumns={2}
            style={{maxHeight: 150, marginBottom: 10}}
            showsVerticalScrollIndicator={true}
            columnWrapperStyle={styles.flatListSelect}
            nestedScrollEnabled={true}
            scrollEnabled={true}
          />

          <Text
            style={[
              styles.text,
              {
                color: R.colors.blue,
                fontWeight: '600',
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Tài liệu đính kèm
          </Text>

          <TouchableOpacity style={styles.containerBtn}>
            <Text style={styles.textBtn}>
              Quyết định thông báo đào tạo - QD347583
            </Text>
            <Image
              source={R.images.icDownload}
              style={{width: 20, height: 20}}
              resizeMode="contain"
              tintColor={R.colors.blue}
            />
          </TouchableOpacity>
        </View>
      </ScrollView>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Văn bản đi 2038475'} isBack />
      <View style={{flex: 1}}>{body()}</View>
    </View>
  );
};

export default ApprovalView;
