import React from 'react';
import {Text, View, TouchableOpacity, FlatList, Image} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import Button from '../../components/Button';
import R from '../../assets/R';
import * as SCREENNAME from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';

const ClassActivityView = props => {
  const {dataList, setDataList} = props;
  const navigate = useNavigation();

  const renderItem = ({item}) => {
    return (
      <View style={styles.containerCard}>
        <Text style={styles.text_title}>
          Lớp sinh hoạt: <Text style={styles.text}>{item.class_activity}</Text>
        </Text>
        <View style={styles.containerText}>
          <Text style={styles.text_title}>
            Khoá: <Text style={styles.text}>{item.course}</Text>
          </Text>
          <View style={styles.sizedBox}></View>
          <Text style={styles.text_title}>
            Hệ ĐT: <Text style={styles.text}>{item.training_system}</Text>
          </Text>
        </View>
        <Text style={styles.text_title}>
          Lớp theo khoa: <Text style={styles.text}>{item.class_by_course}</Text>
        </Text>
        <Text style={styles.text_title}>
          Khoa: <Text style={styles.text}>{item.science}</Text>
        </Text>
        <Text style={styles.text_title}>
          Lớp trưởng: <Text style={styles.text}>{item.class_leader}</Text>
        </Text>
        <View style={styles.containerButton}>
          <Button
            title="Chi tiết"
            onPress={() => {
              navigate.navigate(SCREENNAME.LISTSTUDENTCLASS);
            }}
            backgroundColor={R.colors.blue}
            textColor={R.colors.white}
            height={30}
            borderRadius={15}
            fontSize={R.sizes.sm}
            fontWeight={'600'}
            fontFamily={R.fonts.fontMedium}
            paddingHorizontal={15}
            paddingVertical={3}
          />
        </View>
      </View>
    );
  };
  const renderItemEmpty = () => {
    return (
        <View style={styles.containerEmpty}>
          <Image source={R.images.icNoData} maxWidth={50} maxHeight={50} />
          <Text style={styles.textEmpty}>Không có dữ liệu</Text>
        </View>
    );
  };
  const renderList = () => {
    return (
        <FlatList
        data={dataList || []}
        renderItem={renderItem}
        showsVerticalScrollIndicator={false}
        vertical
        keyExtractor={(item, index) => `${index}`}
      />
    );
  };
  const renderHeaderBody = () => {
    return (
      <View style={styles.card}>
        <TouchableOpacity style={styles.btnCard} onPress={() => {}}>
          <Text style={[styles.text, styles.textHeader]}>Khoá 2024</Text>
        </TouchableOpacity>
      </View>
    );
  };

  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderHeaderBody()}
        <View style={styles.containerList}>
          {dataList?.length > 0 ? renderList() : renderItemEmpty()}
        </View>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Danh sách lớp sinh hoạt'} isBack />
      {renderBody()}
    </View>
  );
};

export default ClassActivityView;
