import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  TextInput,
  FlatList,
} from 'react-native';
import styles from './style';
import FAB from '../../components/FAB/fab';
import SubButton from '../../components/FAB/sub_button';
import Header from '../../components/Header/Header';
import Dropdown from '../../components/DropdownAlert/Dropdown';
import R from '../../assets/R';
import TabViewComponent from '../../components/TabView';
import AddWorkModal from './modal_add_deliver_to_me/index';
import AddMonitoringModal from './modal_add_monitoring/index';
import Button from '../../components/Button';
import {ROLE} from '../../actions/actionTypes';

const ListWorkView = props => {
  const {
    searchQuery,
    setSearchQuery,
    dataList,
    modalDeliverToMeVisible,
    modalMonitoringVisible,
    tabView,
    currentTabKey,
    shouldShowFAB,
    onFilterChange,
    onAddWork,
    onSaveDeliverToMeWork,
    onSaveMonitoringWork,
    onCloseDeliverToMeModal,
    onCloseMonitoringModal,
    onViewDetailDeliverToMe,
    onReportAction,
    onApprovalAction,
    getStatusColor,
    getButtonsForStatus
  } = props;

  const renderTabView = () => {
    return (
      <TabViewComponent
        data={tabView}
        tabStyle={styles.item_tab_view}
        style={styles.container_tab_view}
        mode="filter"
        defaultActiveKey="all"
        scrollable={true}
        activeTabStyle={styles.active_tab_view}
        textStyle={styles.text_tab_view}
        showActiveIndicator={false}
        onFilterChange={onFilterChange}
      />
    );
  };

  const renderActionButtons = item => {
    const buttons = getButtonsForStatus(item.status, item);

    return buttons.map((button, index) => (
      <Button
        key={index}
        title={button.title}
        onPress={() => {
          if (button.action === 'approve' || button.action === 'needsEdit') {
            onApprovalAction(item, button.action);
          } else {
            onReportAction(item, button.action);
          }
        }}
        backgroundColor={button.backgroundColor}
        textColor={R.colors.white}
        fontSize={11}
        height={30}
        width={100}
        containerStyle={{marginRight: 10, borderRadius: 20}}
      />
    ));
  };

  const renderListView = ({item}) => {
    return (
      <TouchableOpacity
        style={{marginHorizontal: 15, marginVertical: 10}}
        onPress={() => onViewDetailDeliverToMe(item)}
        activeOpacity={0.7}>
        <View
          style={{
            backgroundColor: getStatusColor(item.status),
            borderTopLeftRadius: 15,
            borderTopRightRadius: 15,
          }}>
          <Text
            style={[
              styles.subText,
              {
                marginHorizontal: 15,
                fontFamily: R.fonts.fontMedium,
                fontWeight: '600',
                color: R.colors.white,
              },
            ]}>
            {item.status}
          </Text>
        </View>
        <View style={styles.containerCard}>
          <View style={{paddingHorizontal: 15, paddingTop: 10}}>
            <Text style={styles.text}>{item.title}</Text>
            <View
              style={{flexDirection: 'row', justifyContent: 'space-between'}}>
              <Text style={styles.text}>
                Ngày đến hạn:
                <Text style={styles.subText}>{item.deadline}</Text>
              </Text>
            </View>
            <Text style={styles.text}>
              Người giám sát:
              <Text style={styles.subText}>
                {item.supervisor.map(item => item.name).join(', ')}
              </Text>
            </Text>
            <Text style={styles.text}>
              Thuộc văn bản:
              <Text style={styles.subText}>{item.document}</Text>
            </Text>
          </View>

          <View
            style={{
              flexDirection: 'row',
              justifyContent: 'flex-end',
              marginTop: 10,
            }}>
            {renderActionButtons(item)}
          </View>
        </View>
      </TouchableOpacity>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Danh sách công việc'} isBack />
      <View style={styles.body}>
        {renderTabView()}

        <View style={{marginBottom: 15, flex: 1}}>
          <View style={styles.card}>
            <TouchableOpacity style={styles.btnCard}>
              <Text style={styles.text}>Học kỳ 2, Năm 2025</Text>
            </TouchableOpacity>
          </View>

          <View style={styles.box_3}>
            <View style={styles.searchBox}>
              <Image
                source={R.images.icSearch}
                style={{width: 20, height: 20}}
              />
              <View style={{flex: 1 , padding:0 , margin:0, height:30}}>
                <TextInput 

                  placeholder="Tìm kiếm"
                  style={[styles.text, {height:30 , padding:0, marginRight:15}]}
                  value={searchQuery}
                  onChangeText={setSearchQuery}
                />
              </View>
            </View>
            <View style={{flex: 0.1}}></View>

            <View style={{flex: 1}}>
              <Dropdown title={'Tìm kiếm'} height={30} />
            </View>
          </View>
          <FlatList
            data={dataList}
            renderItem={renderListView}
            keyExtractor={item => item.id.toString()}
            showsVerticalScrollIndicator={false}
          />
        </View>
      </View>
      
      {shouldShowFAB && (
        <FAB>
          <SubButton
            onPress={onAddWork}
            label={currentTabKey === ROLE.ASSIGNEE ? "Tạo công việc" : "Tạo giám sát"}
            images={R.images.icMenuEdit}
            backgroundColor={R.colors.blue}
          />
        </FAB>
      )}

      <AddWorkModal
        visible={modalDeliverToMeVisible}
        onClose={onCloseDeliverToMeModal}
        onSave={onSaveDeliverToMeWork}
      />

      <AddMonitoringModal
        visible={modalMonitoringVisible}
        onClose={onCloseMonitoringModal}
        onSave={onSaveMonitoringWork}
      />
    </View>
  );
};

export default ListWorkView;
