import React, {useState} from 'react';
import DetailListWorkDeliverToMeView from './view';

const DetailListWorkDeliverToMe = props => {
  const [data, setData] = useState({
    id: 1,
    title: 'Tạo thời khóa biểu cho sinh viến khai giảng và học kỳ 2 năm 2025',
    status: 'Chờ duyệt',
    deadline: '2025-09-04',
    supervisor: [
      {
        id: 1,
        name: 'Trần Văn Hùng',
      },
      {
        id: 2,
        name: 'Nguyễn Văn A',
      },
    ],
    implementer: [
      {
        id: 1,
        name: 'Trần Văn Hùng',
      },
      {
        id: 2,
        name: 'Nguyễn Văn A',
      },
    ],
    document: 'Văn bản thông báo lịch nộp thời khóa biểu của học kỳ 2 năm 2025',
    content:
      'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
  });

  const [dataList, setDataList] = useState([
    {id: 1, name: 'Nguyễn Minh Đức'},
    {id: 2, name: 'Trần Văn Hùng'},
    {id: 3, name: 'Lê Thị Mai'},
    {id: 4, name: 'Phạm Quốc Khánh'},
    {id: 5, name: 'Hoàng Anh Tuấn'},
    {id: 6, name: 'Vũ Thị Hằng'},
    {id: 7, name: 'Ngô Văn Nam'},
    {id: 8, name: 'Đinh Thị Lan'},
    {id: 9, name: 'Bùi Văn Phúc'},
    {id: 10, name: 'Lý Thị Hoa'},
    {id: 11, name: 'Phan Minh Hoàng'},
    {id: 12, name: 'Tạ Thị Hương'},
    {id: 13, name: 'Đoàn Văn Dũng'},
    {id: 14, name: 'Nguyễn Thị Vân'},
    {id: 15, name: 'Trương Văn Long'},
    {id: 16, name: 'Mai Thị Ngọc'},
    {id: 17, name: 'Huỳnh Quốc Việt'},
    {id: 18, name: 'Lâm Thị Thu'},
    {id: 19, name: 'Nguyễn Hữu Tài'},
    {id: 20, name: 'Phạm Thị Kim'},
  ]);

  const [dataReport, setDataReport] = useState([
    {
      id: 1,
      title: 'Báo cáo lần 1',
      time: '16:00',
      date: '2025-07-24',
      content:
        'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
      fileTitle: 'Quyết định thông báo đào tạo - QD347583',
      responder: [
        {
          id: 1,
          name: 'Bùi tiến dũng',
          code: '08569',
          time: '16:00',
          date: '2025-07-24',
          content:
            'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
        },
        {
          id: 2,
          name: 'Bùi tiến dũng',
          code: '08569',
          time: '16:00',
          date: '2025-07-24',
          content:
            'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
        },
        {
          id: 3,
          name: 'Bùi tiến dũng',
          code: '08569',
          time: '16:00',
          date: '2025-07-24',
          content:
            'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
        },
      ],
    },
    {
      id: 2,
      title: 'Báo cáo lần 2',
      time: '16:00',
      date: '2025-07-24',
      content:
        'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
      fileTitle: 'Quyết định thông báo đào tạo - QD347583',
      responder: [
        {
          id: 1,
          name: 'Bùi tiến dũng',
          code: '08569',
          time: '16:00',
          date: '2025-07-24',
          content:
            'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
        },
        {
          id: 2,
          name: 'Bùi tiến dũng',
          code: '08569',
          time: '16:00',
          date: '2025-07-24',
          content:
            'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
        },
        {
          id: 3,
          name: 'Bùi tiến dũng',
          code: '08569',
          time: '16:00',
          date: '2025-07-24',
          content:
            'Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan',
        },
      ],
    },
  ]);

  return (
    <DetailListWorkDeliverToMeView
      data={data}
      dataList={dataList}
      dataReport={dataReport}
    />
  );
};

export default DetailListWorkDeliverToMe;
