import {StyleSheet, Text, View} from 'react-native';
import React from 'react';
import R from '../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  card: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 5,
    marginVertical:10,
    alignItems: 'center',
    justifyContent: 'center',
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
    marginHorizontal: 15,
  },
  btnCard: {
    borderRadius: 10,
    borderWidth: 1,
    padding: 5,
    width: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  text: {
    fontSize: R.sizes.sm,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  searchContainer: {
    flexDirection: 'row',
    alignItems: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
    borderWidth: 1,
    borderRadius: 100,
    paddingHorizontal: 10,
    marginHorizontal: 15,
    marginBottom:10,
  },
  textInput: {
    fontSize: R.sizes.sm,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    padding: 0,
    margin: 0,
    flex: 1,
    height: 35,
  },
  iconSearch: {
    width: 24,
    height: 24,
  },

  item: {
    paddingVertical: 10,
    paddingHorizontal: 15,
    marginHorizontal: 15,
    marginVertical:7.5,
    backgroundColor: R.colors.white,
    borderRadius: 15,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  row: {
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  textTitle: {
    fontSize: R.sizes.sm,
    color: R.colors.black,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
  },
  btnContainer: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginVertical: 5,
  },
  iconQR: {
    width: 24,
    height: 24,
  },
});

export default styles;
