import React, {useState} from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  FlatList,
  ScrollView,
  LogBox,
} from 'react-native';
import styles from './style';
import FAB from '../../../components/FAB/fab';
import SubButton from '../../../components/FAB/sub_button';
import R from '../../../assets/R';
import Header from '../../../components/Header/Header';
import Dropdown from '../../../components/DropdownAlert/Dropdown';

const DetailListWorkMonitoringView = props => {
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const {data, dataList, dataReport} = props;
  const [showApprovalModal, setShowApprovalModal] = useState(false);
  const [showRequestEditModal, setShowRequestEditModal] = useState(false);
  
  const getColor = status => {
    switch (status) {
      case 'Chờ duyệt':
        return R.colors.blue;
      case 'Hoàn thành':
        return R.colors.green;
      case 'Đợi chỉnh sửa':
        return R.colors.orange;
      case 'Đang thực hiện':
        return R.colors.orange;
      case 'Đợi báo cáo':
        return R.colors.blue;
      default:
        return R.colors.gray;
    }
  };

  const renderReportItem = ({item}) => {
    return (
      <View style={styles.containerCard}>
        <View style={{flexDirection: 'row', marginBottom: 3}}>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.title} -{' '}
          </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.time}{' '}
          </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.date}
          </Text>
        </View>
        <Text style={styles.text}>{item.content}</Text>
        <View style={styles.sizedBox} />
        <View style={styles.containerText}>
          <Text style={styles.text}>Tệp đính kèm: </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.fileTitle}
          </Text>
        </View>
        <View style={styles.sizedBox} />
        <FlatList
          data={item.responder}
          renderItem={renderResponderItem}
          keyExtractor={item => item.id.toString()}
        />
      </View>
    );
  };

  const renderResponderItem = ({item}) => {
    return (
      <View style={styles.containerCard}>
        <View style={{flexDirection: 'row', marginBottom: 3}}>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.name} - {item.code} -{' '}
          </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.time}{' '}
          </Text>
          <Text style={[styles.text, {color: R.colors.blue}]}>
            {item.date}
          </Text>
        </View>
        <Text style={styles.text}>{item.content}</Text>
      </View>
    );
  };

  const renderImplementerItem = ({item}) => {
    return (
      <View style={styles.containerText}>
        <Text style={styles.text}>{item.name}</Text>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Chi tiết công việc giám sát'} />
      <ScrollView style={styles.body}>
        <View style={styles.containerCard}>
          <View
            style={[
              styles.containerText,
              {backgroundColor: getColor(data.status)},
            ]}>
            <Text style={[styles.text, {color: R.colors.white}]}>
              {data.status}
            </Text>
          </View>
          <View style={styles.sizedBox} />
          <Text style={styles.text}>{data.title}</Text>
          <View style={styles.sizedBox} />
          <View style={styles.containerText}>
            <Text style={styles.text}>Ngày đến hạn: </Text>
            <Text style={[styles.text, {color: R.colors.blue}]}>
              {data.deadline}
            </Text>
          </View>
          <View style={styles.sizedBox} />
          <View style={styles.containerText}>
            <Text style={styles.text}>Người thực hiện: </Text>
          </View>
          <FlatList
            data={data.implementer}
            renderItem={renderImplementerItem}
            keyExtractor={item => item.id.toString()}
          />
          <View style={styles.sizedBox} />
          <View style={styles.containerText}>
            <Text style={styles.text}>Thuộc văn bản: </Text>
            <Text style={[styles.text, {color: R.colors.blue}]}>
              {data.document}
            </Text>
          </View>
          <View style={styles.sizedBox} />
          <Text style={styles.text}>{data.content}</Text>
        </View>

        <View style={styles.containerCard}>
          <Text style={styles.text}>Lịch sử báo cáo</Text>
          <View style={styles.sizedBox} />
          <FlatList
            data={dataReport}
            renderItem={renderReportItem}
            keyExtractor={item => item.id.toString()}
          />
        </View>
      </ScrollView>

      <FAB
        style={styles.fab}
        onPress={() => console.log('FAB pressed for monitoring actions')}>
        <SubButton
          onPress={() => setShowApprovalModal(true)}
          title={'Phê duyệt'}
        />
        <SubButton
          onPress={() => setShowRequestEditModal(true)}
          title={'Yêu cầu chỉnh sửa'}
        />
        <SubButton
          onPress={() => console.log('Request report')}
          title={'Yêu cầu báo cáo'}
        />
      </FAB>
    </View>
  );
};

export default DetailListWorkMonitoringView;
