import { StyleSheet } from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    marginHorizontal: 15,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
  },
  sub_text: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
  },
  containerCard: {
    borderWidth: 1,
    borderRadius: 10,
    padding: 10,
    marginBottom: 10,
    borderColor: R.colors.grayBorderInputTextHeader,
    backgroundColor: R.colors.white,
  },
  containerText: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderRadius: 5,
  },
  sizedBox: {
    height: 10,
  },
  fab: {
    position: 'absolute',
    bottom: 20,
    right: 20,
  },
  containerFile: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    borderRadius: 10,
    backgroundColor: R.colors.blue1,
    marginBottom: 5,
    height: 30,
    paddingHorizontal: 10,
  },
  image: {
    width: 20,
    height: 20,
  },
});

export default styles;