import {StyleSheet, Text, View, Dimensions} from 'react-native';
import R from '../../assets/R';
const {width, height} = Dimensions.get('window');
const widthLibary = width / 7;
const heightLibary = height / 14;
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    padding: 15,
  },
  headerBody: {
    flexDirection: 'row',
    marginBottom: 15,
  },
  headerLeft: {
    // backgroundColor:'red'
  },
  boxCamera: {
    alignItems: 'center',
    justifyContent: 'center',
    maxWidth: 120,
  },
  containerImage: {
    backgroundColor: R.colors.grayBorderInputTextHeader,
    width: 100,
    height: 150,
    justifyContent: 'center',
    alignItems: 'center',
    borderRadius: 10,
  },
  image: {
    width: 100,
    height: 150,
    borderRadius: 10,
  },
  containerButton: {
    marginTop: 10,
  },

  headerRight: {
    flex: 1,
    marginLeft: 15,
    justifyContent: 'flex-start',
  },
  text: {
    fontSize: R.sizes.sm,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  bodyProfile: {},
  containerInput: {
    flexDirection: 'row',
    marginBottom: 15,
    justifyContent: 'space-between',
  },
  sizedBox: {
    width: 15,
  },
  topLeft: {
    position: 'absolute',
    top: 15,
    left: 15,
  },
  topRight: {
    position: 'absolute',
    top: 15,
    right: 15,
  },
  bottomLeft: {
    position: 'absolute',
    bottom: heightLibary,
    left: widthLibary,
  },
  bottomRight: {
    position: 'absolute',
    bottom: 15,
    right: 15,
  },
  shutter: {
    position: 'absolute',
    bottom: 50,
    left: '40%',
    width: 68,
    height: 68,
    borderRadius: 34,
    borderWidth: 4,
    borderColor: '#fff',
    backgroundColor: 'rgba(255,255,255,0.2)',
  },

  overlay: {
    position: 'absolute',
    top: 0,
    left: 0,
    right: 0,
    bottom: 0,
    backgroundColor: 'black',
  },

  smallBtn: {
    paddingHorizontal: 12,
    paddingVertical: 8,
    borderRadius: 8,
    backgroundColor: 'transparent',
  },
  btnText: {color: '#fff', fontWeight: '600'},
  absoluteFill: {position: 'absolute', top: 0, left: 0, right: 0, bottom: 0},
  center: {justifyContent: 'center', alignItems: 'center'},

  // Gallery Preview Styles
  galleryPreview: {
    width: 60,
    height: 60,
    borderRadius: 8,
    backgroundColor: 'rgba(0, 0, 0, 0.3)',
    justifyContent: 'center',
    alignItems: 'center',
    borderWidth: 2,
    borderColor: 'rgba(255, 255, 255, 0.3)',
  },
  galleryGrid: {
    width: '100%',
    height: '100%',
    flexDirection: 'row',
    flexWrap: 'wrap',
    borderRadius: 6,
    overflow: 'hidden',
  },
  galleryThumbnail: {
    width: '50%',
    height: '50%',
    borderWidth: 0.5,
    borderColor: 'rgba(255, 255, 255, 0.2)',
  },

  // Image Source Modal Styles
  modalOverlay: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    justifyContent: 'flex-end',
  },
  modalContainer: {
    backgroundColor: R.colors.white,
    borderTopLeftRadius: 20,
    borderTopRightRadius: 20,
    paddingHorizontal: 20,
    paddingVertical: 30,
    minHeight: 250,
  },
  modalTitle: {
    fontSize: R.sizes.lg,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
    textAlign: 'center',
    marginBottom: 30,
  },
  modalOption: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 15,
    paddingHorizontal: 20,
    backgroundColor: R.colors.grayLight || '#f5f5f5',
    borderRadius: 10,
    marginBottom: 15,
  },
  modalIcon: {
    width: 24,
    height: 24,
    marginRight: 15,
    tintColor: R.colors.blue,
  },
  modalOptionText: {
    fontSize: R.sizes.md,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '500',
    color: R.colors.black,
  },
  modalCancelButton: {
    paddingVertical: 15,
    alignItems: 'center',
    marginTop: 10,
  },
  modalCancelText: {
    fontSize: R.sizes.md,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '500',
    color: R.colors.gray,
  },

  // Preview Modal Styles
  previewContainer: {
    flex: 1,
    backgroundColor: R.colors.black,
  },
  previewHeader: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 20,
    paddingVertical: 15,
    paddingTop: 50,
    backgroundColor: 'rgba(0, 0, 0, 0.8)',
  },
  previewCloseButton: {
    padding: 10,
  },
  previewCloseIcon: {
    width: 24,
    height: 24,
    tintColor: R.colors.white,
  },
  previewTitle: {
    fontSize: R.sizes.lg,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.white,
  },
  previewSpacer: {
    width: 44,
  },
  previewImageContainer: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  previewImage: {
    width: '100%',
    height: '100%',
  },
  previewActions: {
    flexDirection: 'row',
    justifyContent: 'space-around',
    paddingHorizontal: 40,
    paddingVertical: 30,
    backgroundColor: 'rgba(0, 0, 0, 0.8)',
  },
  previewRetakeButton: {
    paddingVertical: 12,
    paddingHorizontal: 30,
    borderRadius: 25,
    borderWidth: 2,
    borderColor: R.colors.white,
    backgroundColor: 'transparent',
  },
  previewRetakeText: {
    fontSize: R.sizes.md,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.white,
    textAlign: 'center',
  },
  previewConfirmButton: {
    paddingVertical: 12,
    paddingHorizontal: 30,
    borderRadius: 25,
    backgroundColor: R.colors.blue,
  },
  previewConfirmText: {
    fontSize: R.sizes.md,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.white,
    textAlign: 'center',
  },
});
export default styles;
