import React, {useState} from 'react';
import {
  Modal,
  View,
  Text,
  TextInput,
  TouchableOpacity,
  StyleSheet,
  Image,
} from 'react-native';
import R from '../../../../../assets/R';
import Button from '../../../../../components/Button';

const EditReportModal = ({visible, onClose, onSubmit, initialContent = ''}) => {
  const [reportContent, setReportContent] = useState(initialContent);

  const handleSubmit = () => {
    if (reportContent.trim()) {
      onSubmit(reportContent);
      onClose();
    }
  };

  const handleCancel = () => {
    setReportContent(initialContent);
    onClose();
  };

  return (
    <Modal
      visible={visible}
      transparent={true}
      animationType="slide"
      onRequestClose={onClose}>
      <View style={styles.overlay}>
        <View style={styles.modalContainer}>
          <Text style={styles.title}>Chỉnh sửa báo cáo</Text>
          <Text style={styles.text}>
            Nội dung báo cáo
            <Text style={styles.required}>*</Text>
          </Text>
          <Text style={styles.description}>
            Bạn đã nộp yêu cầu nhưng thành thời khoa chưa trong thông cho cần
            đánh giá môn học các công việc và lịch hẹn quan
          </Text>

          <Text style={styles.text}>Tài liệu đính kèm</Text>

          <View style={styles.attachedFileContainer}>
            <Text style={styles.fileName}>
              Quyết định thông báo đào tạo - QD347583
            </Text>
            <TouchableOpacity>
              <Image source={R.images.icCancel} style={styles.deleteIcon} />
            </TouchableOpacity>
          </View>

          <TouchableOpacity style={styles.attachmentContainer}>
            <Image source={R.images.icDocument} style={styles.uploadIcon} />
            <Text style={styles.attachmentText}>Thêm tài liệu</Text>
          </TouchableOpacity>

          <View style={styles.buttonContainer}>
            <Button
              title="Hủy"
              onPress={handleCancel}
              backgroundColor={R.colors.orange}
              width={100}
              height={35}
              borderRadius={100}
              marginRight={10}
              fontSize={R.fontsize.fontSizeContent}
              textColor={R.colors.white}
            />
            <Button
              title="Cập nhật"
              onPress={handleSubmit}
              backgroundColor={R.colors.blue}
              width={100}
              height={35}
              borderRadius={100}
              fontSize={R.fontsize.fontSizeContent}
              textColor={R.colors.white}
            />
          </View>
        </View>
      </View>
    </Modal>
  );
};

const styles = StyleSheet.create({
  overlay: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContainer: {
    backgroundColor: 'white',
    borderRadius: 12,
    padding: 20,
    width: '90%',
    maxWidth: 400,
  },
  title: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontWeight: '600',
    color: R.colors.blue,
    textAlign: 'center',
  },
  description: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.gray1,
    lineHeight: 18,
    marginBottom: 10,
    textAlign: 'left',
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 10,
  },
  required: {
    color: R.colors.red,
  },

  attachedFileContainer: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    backgroundColor: R.colors.blue1,
    borderRadius: 10,
    padding: 10,
    marginBottom: 10,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  fileName: {
    fontSize: R.sizes.xs,
    color: R.colors.black,
  },
  deleteIcon: {
    width: 20,
    height: 20,
    tintColor: R.colors.blue,
  },
  attachmentContainer: {
    borderWidth: 1,
    borderColor: R.colors.blue,
    borderRadius: 10,
    padding: 20,
    alignItems: 'center',
    marginBottom: 20,
  },
  uploadIcon: {
    width: 23,
    height: 28,
    tintColor: R.colors.blue,
    marginBottom: 5,
  },
  attachmentText: {
    fontSize: 14,
    color: R.colors.blue,
    fontWeight: '500',
  },
  buttonContainer: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
  },
  cancelButton: {
    flex: 1,
    backgroundColor: R.colors.orange,
    borderRadius: 8,
    paddingVertical: 12,
    alignItems: 'center',
  },
  submitButton: {
    flex: 1,
    backgroundColor: R.colors.blue,
    borderRadius: 8,
    paddingVertical: 12,
    alignItems: 'center',
  },
  cancelButtonText: {
    color: 'white',
    fontSize: 16,
    fontWeight: '600',
  },
  submitButtonText: {
    color: 'white',
    fontSize: 16,
    fontWeight: '600',
  },
});

export default EditReportModal;
