import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  FlatList,
  Image,
  ScrollView,
} from 'react-native';
import Header from '../../../components/Header/Header';
import R from '../../../assets/R';
import {useNavigation} from '@react-navigation/native';
import * as ScreenName from '../../../routers/ScreenNames';
import Button from '../../../components/Button';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import styles from './style';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
const AddSendDocumentView = props => {
  const {dataList} = props;
  const navigation = useNavigation();

  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity style={styles.containerIcon} onPress={onPress}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };

  const body = () => {
    return (
      <View style={styles.body}>
        <View style={styles.row_1}>
          <Text style={styles.sub_text}>
            Ngày tạo: <Text style={styles.sub_text}>29/07/2025</Text>
          </Text>
          <Text style={styles.sub_text}>
            Trạng thái:{' '}
            <Text style={[styles.sub_text, {color: R.colors.orange}]}>
              Dự thảo
            </Text>
          </Text>
        </View>
        <TextField
          title="Tiêu đề"
          required
          fontSize={R.fontsize.fontSizeContent}
          fontSizeTitle={R.fontsize.fontSizeContent}
          fontFamily={R.fonts.fontSemiBold}
          placeholder="Nhập tiêu đề"
          containerMarginBottom={10}
        />
        <TextMulti
          title="Nội dung văn bản"
          required
          fontSize={R.fontsize.fontSizeContent}
          titleFontSize={R.fontsize.fontSizeContent}
          fontFamily={R.fonts.fontSemiBold}
          placeholder="Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan"
          containerMarginBottom={10}
          numberOfLines={3}
        />
        <TextMulti
          title="Ghi chú"
          fontSize={R.fontsize.fontSizeContent}
          titleFontSize={R.fontsize.fontSizeContent}
          fontFamily={R.fonts.fontSemiBold}
          placeholder="Ban lãnh đạo yêu cầu hoàn thành thời khóa biểu trong tháng cho các đơn vị chuyên môn sắp xếp các công việc và lịch liên quan"
          containerMarginBottom={10}
          numberOfLines={3}
        />
        <TextField
          fontSize={R.fontsize.fontSizeContent}
          titleFontSize={R.fontsize.fontSizeContent}
          fontFamily={R.fonts.fontSemiBold}
          title="Loại văn bản"
          required
          containerMarginBottom={10}
        />
        <TextField
          title="Loại vực văn bản"
          required
          containerMarginBottom={10}
        />

        <View style={styles.containerDropdown}>
          <Text style={[{marginBottom: 3}, styles.sub_text]}>
            Chế độ <Text style={{color: R.colors.red}}>*</Text>
          </Text>
          <Dropdown
            title="Chế độ"
            required
            containerMarginBottom={10}
            height={35}
          />
        </View>

        <View style={styles.containerDropdown}>
          <Text style={[{marginBottom: 3}, styles.sub_text]}>
            Phòng ban nhận <Text style={{color: R.colors.red}}>*</Text>
          </Text>
          <Dropdown
            title="Chế độ"
            required
            containerMarginBottom={10}
            height={35}
          />
        </View>
        <Text style={[{marginBottom: 3}, styles.sub_text]}>
          Danh sách phòng ban nhận đã chọn :
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150, marginBottom: 10}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <View style={styles.containerDropdown}>
          <Text style={[{marginBottom: 3}, styles.sub_text]}>
            Nhóm người nhận <Text style={{color: R.colors.red}}>*</Text>
          </Text>
          <Dropdown
            title="Chế độ"
            required
            containerMarginBottom={10}
            height={35}
          />
        </View>
        <Text style={[{marginBottom: 3}, styles.sub_text]}>
          Danh sách nhóm người nhận đã chọn :
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150, marginBottom: 10}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <View style={styles.containerDropdown}>
          <Text style={[{marginBottom: 3}, styles.sub_text]}>
            Người nhận <Text style={{color: R.colors.red}}>*</Text>
          </Text>
          <Dropdown
            title="Chế độ"
            required
            containerMarginBottom={10}
            height={35}
          />
        </View>
        <Text style={[{marginBottom: 3}, styles.sub_text]}>
          Danh sách người nhận đã chọn :
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150, marginBottom: 10}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />
        {footer()}
      </View>
    );
  };

  const footer = () => {
    return (
      <View style={styles.footer}>
        <Text style={[styles.sub_text, {color: R.colors.blue}]}>
          Tài liệu đính kèm
        </Text>

        <TouchableOpacity style={styles.containerBtn}>
          <Text style={styles.text}>
            Quyết định thông báo đào tạo - QD347583
          </Text>
          <Image
            source={R.images.icCancel}
            style={{width: 20, height: 20}}
            resizeMode="contain"
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>

        <TouchableOpacity style={styles.button}>
          <Image
            source={R.images.icDocument}
            style={{width: 35, height: 35}}
            resizeMode="contain"
            tintColor={R.colors.blue}
          />
          <Text style={[styles.sub_text, {color: R.colors.blue}]}>
            Thêm tài liệu
          </Text>
        </TouchableOpacity>
        <Button
          title="Tạo văn bản"
          onPress={() => {}}
          backgroundColor={R.colors.blue}
          textColor={R.colors.white}
          borderRadius={15}
          paddingVertical={3}
          containerMarginBottom={10}
        />
      </View>
    );
  };
  return (
    <View style={styles.container}>
      <Header title={'Tạo mới văn bản đi'} isBack />
      <ScrollView showsVerticalScrollIndicator={false}>{body()}</ScrollView>
    </View>
  );
};

export default AddSendDocumentView;
