import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  FlatList,
  LogBox,
} from 'react-native';
import styles from './style';
import Header from '../../../components/Header/Header';
import R from '../../../assets/R';
import Button from '../../../components/Button';
import {useNavigation} from '@react-navigation/native';
import * as SCREENNAME from '../../../routers/ScreenNames';

const AbsenceListByCourseView = props => {
  const {item, listData} = props;
  const navigation = useNavigation();
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);

  const getColor = status => {
    switch (status) {
      case 'Đã xác nhận':
        return R.colors.green1;
      case 'Chờ phê duyệt':
        return R.colors.blue;
    }
  };

  const renderItem = ({item}) => {
    return (
      <View style={styles.card}>
        <View style={styles.statusHeaderContainer}>
          <View style={[styles.statusHeader, {backgroundColor: getColor(item.status)}]}>
            <Text style={[styles.text, styles.statusText]}>
              <Text style={styles.statusTextInner}>
                {item.status}
              </Text>
            </Text>
          </View>
        </View>

        <View style={styles.cardContent}>
          {/* Row 1 */}
          <View style={styles.row}>
            <View style={styles.rowFlex}>
              <Text style={[styles.text, styles.labelText]}>
                Ngày báo nghỉ: {''}
                <Text style={[styles.text, styles.valueText]}>
                  {item.date}
                </Text>
              </Text>
            </View>
          </View>
          {/* Row 2 */}
          <View>
            <Text style={[styles.text, styles.labelText]}>
              Thời gian nghỉ:{' '}
              <Text style={[styles.text, styles.valueText]}>
                {item.dayOfWeek} - Tiết:{' '}
                {item.periods.map((item, index) => {
                  return <Text key={index}>{item.time},</Text>;
                })}{' '}
                - Ngày:{item.dateStudy}
              </Text>
            </Text>
          </View>
          {/* Row 3 */}
          <View>
            <Text style={[styles.text, styles.labelText]}>
              Địa điểm:
              <Text style={[styles.text, styles.valueText]}>
                {item.location}
              </Text>
            </Text>
          </View>
          {/* Row 4 */}
          <View>
            <Text style={[styles.text, styles.labelText]}>
              Giảng viên thay thế:
              <Text style={[styles.text, styles.valueText]}>
                {item.teacher}
              </Text>
            </Text>
          </View>
          {/* Row 5 */}
          <View>
            <Text style={[styles.text, styles.labelText]}>
              Ghi chú:
              <Text style={[styles.text, styles.valueText]}>
                {item.note}
              </Text>
            </Text>
          </View>
          {item.status === 'Đã xác nhận' && (
            <View style={styles.buttonContainer}>
              <Button
                title="Báo bù"
                onPress={() => navigation.navigate(SCREENNAME.LISTMAKEUPCLASSES)}
                backgroundColor={R.colors.blue}
                textColor={R.colors.white}
                height={25}
                width={90}
                borderRadius={15}
                fontSize={11}
                fontWeight={'600'}
                fontFamily={R.fonts.fontMedium}
                paddingHorizontal={15}
              />
            </View>
          )}
          {item.status === 'Chờ phê duyệt' && (
            <View style={styles.buttonContainer}>
              <Button
                title="Huỷ"
                onPress={() => {}}
                backgroundColor={R.colors.orange}
                textColor={R.colors.white}
                height={25}
                width={90}
                borderRadius={15}
                fontSize={11}
                fontWeight={'600'}
                fontFamily={R.fonts.fontMedium}
                paddingHorizontal={15}
              />
            </View>
          )}
        </View>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'ATTT2024.1'} isBack />
      <View style={styles.body}>
        <View style={styles.summaryContainer}>
          <Text style={[styles.text, styles.summaryTitle]}>
            Nghỉ / Bù / Tổng
          </Text>
          <Text style={[styles.text, styles.summaryValue]}>
            {item.rest} / {item.compensate} / {item.total}
          </Text>
        </View>
        <FlatList
          data={listData || []}
          renderItem={renderItem}
          showsVerticalScrollIndicator={false}
          vertical
          keyExtractor={(item, index) => `${index}`}
        />
      </View>
    </View>
  );
};

export default AbsenceListByCourseView;
