import React, {useState} from 'react';
import {Text, View, TouchableOpacity, Image, ScrollView} from 'react-native';
import styles from './style';
import Header from '../../../components/Header/Header';
import R from '../../../assets/R';
import {useNavigation} from '@react-navigation/native';
const DetailEmailView = props => {
  const {incoming_document} = props;
  const navigation = useNavigation();
  const [showBottomCard, setShowBottomCard] = useState(false);
  const renderHeader = () => {
    return (
      <View style={styles.header}>
        <TouchableOpacity onPress={() => navigation.goBack()}>
          <Image
            source={R.images.icBack}
            style={styles.iconBack}
            resizeMode="contain"
          />
        </TouchableOpacity>
        <TouchableOpacity onPress={() => navigation.goBack()}>
          <Image
            source={R.images.icDelete}
            style={styles.iconDelete}
            resizeMode="contain"
          />
        </TouchableOpacity>
      </View>
    );
  };
  const renderBottomCard = () => {
    return (
      <View style={styles.detailSendContainer}>
        <ScrollView nestedScrollEnabled={true} style={{flex: 1}}>
          <Text style={styles.textTitleMail}>
            From:{' '}
            <Text style={styles.textSubMail}>{incoming_document.from}</Text>
          </Text>
          <Text style={styles.textTitleMail}>
            CC:{' '}
            <Text style={styles.textSubMail}>
              {incoming_document.cc.map((item, index) => {
                return <Text key={index}>{item.name},</Text>;
              })}
            </Text>
          </Text>
          <Text style={styles.textTitleMail}>
            BCC: <Text style={styles.textSubMail}>{incoming_document.bcc}</Text>
          </Text>
          <Text style={styles.textTitleMail}>
            TO: <Text style={styles.textSubMail}>{incoming_document.to}</Text>
          </Text>
        </ScrollView>
      </View>
    );
  };

  const renderButton = ({
    title,
    onPress,
    style,
    icon,
    textStyle,
    iconRight,
  }) => {
    return (
      <TouchableOpacity style={style} onPress={onPress}>
        <View
          style={{
            flexDirection: 'row',
            alignItems: 'center',
            justifyContent: 'center',
            marginHorizontal: 10,
          }}>
          <Image source={icon} style={styles.iconReply} resizeMode="contain" />
          <Text style={textStyle}>{title}</Text>
          <Image
            source={iconRight}
            style={[styles.iconForward, {transform: [{rotateY: '180deg'}]}]}
            resizeMode="contain"
          />
        </View>
      </TouchableOpacity>
    );
  };

  const renderBody = () => {
    return (
      <ScrollView showsVerticalScrollIndicator={false} style={styles.body}>
        <Text style={styles.title}>{incoming_document.title}</Text>
        <View style={styles.avatarBox}>
          <View style={styles.avatarContainer}>
            <Image
              source={{uri: incoming_document.avatar}}
              style={styles.avatar}
              resizeMode="cover"
            />
          </View>

          <View style={styles.avatarTextContainer}>
            <View>
              <Text style={styles.name}>{incoming_document.name}</Text>
              <TouchableOpacity
                style={styles.toMeContainer}
                onPress={() => setShowBottomCard(!showBottomCard)}>
                <Text>to me</Text>
                <Image
                  source={R.images.icDrop}
                  style={[
                    styles.iconDrop,
                    {
                      transform: [{rotate: showBottomCard ? '180deg' : '0deg'}],
                    },
                  ]}
                  resizeMode="contain"
                />
              </TouchableOpacity>
            </View>

            <Text style={styles.date}>{incoming_document.date}</Text>
          </View>
        </View>
        {showBottomCard && renderBottomCard()}
        <View style={{marginVertical: 15}}>
          <Text style={styles.textContent}>{incoming_document.content}</Text>
        </View>
        <View
          style={{
            marginBottom: 35,
            flexDirection: 'row',
            justifyContent: 'space-between',
          }}>
          {renderButton({
            title: 'Reply',
            onPress: () => {},
            icon: R.images.icReply,
            style: {
              backgroundColor: R.colors.white,
              padding: 5,
              borderRadius: 15,
              borderColor: R.colors.black,
              borderWidth: 1,
              width: 105,
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
              height: 40,
            },
            textStyle: {
              color: R.colors.black,
              fontSize: R.fontsize.fontSizeLabel,
              fontFamily: R.fonts.fontMedium,
              fontWeight: '600',
              marginLeft: 5,
            },
          })}
          {renderButton({
            title: 'Reply All',
            onPress: () => {},
            icon: R.images.icReplyAll,
            style: {
              backgroundColor: R.colors.white,
              padding: 5,
              borderRadius: 15,
              borderColor: R.colors.black,
              borderWidth: 1,
              width: 105,
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
              height: 40,
            },
            textStyle: {
              color: R.colors.black,
              fontSize: R.fontsize.fontSizeLabel,
              fontFamily: R.fonts.fontMedium,
              fontWeight: '600',
              marginLeft: 5,
            },
          })}
          {renderButton({
            title: 'Forward',
            onPress: () => {},
            iconRight: R.images.icReply,
            style: {
              backgroundColor: R.colors.white,
              padding: 5,
              borderRadius: 15,
              borderColor: R.colors.black,
              borderWidth: 1,
              width: 105,
              flexDirection: 'row',
              alignItems: 'center',
              justifyContent: 'center',
              height: 40,
            },
            textStyle: {
              color: R.colors.black,
              fontSize: R.fontsize.fontSizeLabel,
              fontFamily: R.fonts.fontMedium,
              fontWeight: '600',
              marginRight: 5,
            },
          })}
        </View>
      </ScrollView>
    );
  };
  return (
    <View style={styles.container}>
      {renderHeader()}
      {renderBody()}
    </View>
  );
};

export default DetailEmailView;
