import {StyleSheet, Text, View, Dimensions} from 'react-native';
import R from '../../../assets/R';
//B1: Xác định chiều rộng cột đầu tiên
const width_first = 100;
//B2: Xác định chiều rộng của 15 cột tiếp theo
const width_second = 110;
//B3: Xác định số tiết diễn ra trong 1 ngày -> để có kích thước bảng
const period_count = 15;
//B4: Xác định chiều rộng của bảng
const total_width_table = width_first + width_second * period_count;
const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    padding: 15,
  },
  containerInput: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginBottom: 15,
  },
  txtSubtitle: {
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    fontSize: R.fontsize.fontSizeLabel,
    color: R.colors.black,
  },
  containerDropDown: {
    marginBottom: 15,
  },
  btnRegister: {
    alignItems: 'flex-end',
  },
  btnRegister2: {
    marginVertical: 15,
  },

  //Header bảng lịch
  tableContainer: {
    marginTop: 15,
    borderWidth: 1,
    borderColor: R.colors.gray,
    width: total_width_table,
  },

  headerRow: {
    flexDirection: 'row',
    backgroundColor: R.colors.white,
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray,
  },

  headerText: {
    fontSize: R.sizes.sm,
    fontWeight: '500',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  dateColumn: {
    height: 40,
    width: width_first,
    paddingHorizontal: 10,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.blue2,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray,
  },
  periodColumn: {
    height: 40,
    width: width_second,
    paddingHorizontal: 5,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.blue2,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray,
  },
  dateBody: {
    width: width_first,
    minHeight: 40,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.white,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray,
  },
  periodBody: {
    width: width_second,
    padding: 5,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.white,
    borderRightWidth: 1,
    borderRightColor: R.colors.gray,
  },
  dataRow: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderBottomColor: R.colors.gray,
    minHeight: 50,
  },
  periodCell: {
    padding: 2,
    alignItems: 'center',
    justifyContent: 'center',
    minHeight: 50,
    width: '100%',
  },
  dateText: {
    fontSize: R.sizes.sm,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
  },
  percentText: {
    fontSize: R.sizes.sm,
    fontWeight: '500',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  codeText: {
    fontSize: R.sizes.sm,
    fontWeight: '500',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
});
export default styles;
