import React from 'react';
import {
  StyleSheet,
  TouchableOpacity,
  Platform,
  View,
  Text,
  Image,
} from 'react-native';
import R from '../assets/R';

const Button = props => {
  const {
    title,
    onPress,
    containerStyle,
    txtStyle,
    backgroundColor,
    height,
    borderRadius,
    fontSize,
    textColor,
    fontWeight,
    fontFamily,
    disabled,
    width,
    marginHorizontalText,
    marginVerticalText,
    icon,
    iconStyle,
    paddingHorizontal,
    paddingVertical,
    marginRight,
    iconLeft,
    iconStyleLeft,
    tintColorLeft,
  } = props;

  return (
    <TouchableOpacity
      style={[
        {
          width: width,
          height: height,
          paddingHorizontal: paddingHorizontal,
          paddingVertical: paddingVertical,
          backgroundColor: backgroundColor,
          borderRadius: borderRadius,
          marginRight: marginRight,
        },
        {...containerStyle},
      ]}
      disabled={disabled}
      onPress={onPress}>
      <View
        style={{
          flex: 1,
          justifyContent: 'space-around',
          flexDirection: 'row',
          alignItems: 'center',
        }}>
        {iconLeft && (
          <Image
            source={iconLeft}
            tintColor={tintColorLeft}
            style={iconStyleLeft}
          />
        )}
        <Text
          style={[
            {
              fontSize: fontSize,
              color: textColor,
              fontWeight: fontWeight,
              fontFamily: fontFamily,
              marginHorizontal: marginHorizontalText,
              marginVertical: marginVerticalText,
            },
            {...txtStyle},
          ]}>
          {title}
        </Text>
        {icon && <Image source={icon} style={iconStyle} />}
      </View>
    </TouchableOpacity>
  );
};
export default Button;
