import React, {useState} from 'react';
import {Text, View, StyleSheet} from 'react-native';
import ListSendDocumentView from './view';
import R from '../../assets/R';

const ListSendDocument = props => {
  const [activeTab, setActiveTab] = useState('all');
  const [dataListTabView, setDataListTabView] = useState([
    {
      key: 'all',
      title_status: 'Tất cả',
    },
    {
      key: 'Hạn chế',
      title_status: 'Hạn chế',
    },
    {
      key: 'Công khai',
      title_status: 'Công khai',
    },
  ]);

  const handleTabKey = tabKey => {
    setActiveTab(tabKey);
  };

  const [dataList, setDataList] = useState([
    {
      id: '1',
      title: 'Văn bản thông báo lịch nộp thời khoá biểu của học kì 2 năm 2025',
      symbol_number: '123456789',
      term: '29/07/2025',
      number_entry_book: '12493-fh544',
      status: 'Chờ xét duyệt',
      regime: 'Hạn chế',
    },
    {
      id: '2',
      title: 'Thông báo về quy định thi cuối kì học kì 2 năm 2025',
      symbol_number: '987654321',
      term: '15/08/2025',
      number_entry_book: '12494-gh678',
      status: 'Cần chỉnh sửa',
      regime: 'Hạn chế',
    },
    {
      id: '3',
      title: 'Quyết định về việc nghỉ lễ Tết Nguyên Đán 2025',
      symbol_number: '456789123',
      term: '20/01/2025',
      number_entry_book: '12495-jk901',
      status: 'Đã phê duyệt',
      regime: 'Công khai',
    },
    {
      id: '4',
      title: 'Dự thảo quy chế đánh giá sinh viên mới',
      symbol_number: '789123456',
      term: '10/09/2025',
      number_entry_book: '12496-mn234',
      status: 'Dự thảo',
      regime: 'Công khai',
    },
    {
      id: '5',
      title: 'Thông báo tuyển sinh đại học năm 2025',
      symbol_number: '321654987',
      term: '05/06/2025',
      number_entry_book: '12497-pq567',
      status: 'Đã phê duyệt',
      regime: 'Công khai',
    },
    {
      id: '6',
      title: 'Văn bản hướng dẫn thực hiện công tác an toàn trường học',
      symbol_number: '654987321',
      term: '12/03/2025',
      number_entry_book: '12498-rs890',
      status: 'Chờ xét duyệt',
      regime: 'Hạn chế',
    },
  ]);

  const [searchQuery, setSearchQuery] = useState('');

  const filterData = dataList.filter(item => {
    const matchTab =
      activeTab === 'all' ||
      item.regime === activeTab ||
      item.status === activeTab;
    const matchSearch = item.title
      .toLowerCase()
      .includes(searchQuery.toLowerCase());
    return matchTab && matchSearch;
  });

  const getColorStatus = status => {
      switch (status) {
        case 'Chờ xét duyệt':
          return R.colors.blue;
        case 'Cần chỉnh sửa':
          return R.colors.orange;
        case 'Đã phê duyệt':
          return R.colors.green1;
        case 'Dự thảo':
          return R.colors.orange;
      }
    };
    const getColorRegime = regime => {
      switch (regime) {
        case 'Hạn chế':
          return R.colors.orange;
        case 'Công khai':
          return R.colors.blue;
      }
    };

  return (
    <ListSendDocumentView
      activeTab={activeTab}
      dataListTabView={dataListTabView}
      dataList={filterData}
      searchQuery={searchQuery}
      setSearchQuery={setSearchQuery}
      handleTabKey={handleTabKey}
      getColorStatus={getColorStatus}
      getColorRegime={getColorRegime}

    />
  );
};

export default ListSendDocument;
