import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  FlatList,
  Image,
} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import * as SCREENNAME from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
const CompensateView = props => {
  const {dataList} = props;
  const navigation = useNavigation();
  const renderItem = ({item}) => {
    return (
      <TouchableOpacity
        onPress={() => {
          navigation.navigate(SCREENNAME.MAKEUPSCHEDULELISTBYCOURSE);
        }}
        style={styles.containerCard}>
        <View>
          <Text
            style={[
              styles.text,
              {
                fontWeight: '600',
                fontFamily: R.fonts.fontMedium,
                color: R.colors.blue,
              },
            ]}>
            Lớp: {item.classCode}
          </Text>
        </View>

        <View style={{alignItems: 'center'}}>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Nghỉ / Bù / Tổng
          </Text>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 400,
                fontFamily: R.fonts.fontRegular,
              },
            ]}>
            {item.rest} / {item.compensate} / {item.total}
          </Text>
        </View>

        <View style={styles.btnRight}>
          <Image
            source={R.images.icNext}
            style={{width: 15, height: 15}}
            resizeMode="contain"
            tintColor={R.colors.black}
          />
        </View>
      </TouchableOpacity>
    );
  };

  const renderListClass = () => {
    return (
      <FlatList
        data={dataList || []}
        renderItem={renderItem}
        showsVerticalScrollIndicator={false}
        vertical
        keyExtractor={(item, index) => `${index}`}
      />
    );
  };

  const renderHeaderBody = () => {
    return (
      <View style={styles.card}>
        <TouchableOpacity style={styles.btnCard}>
          <Text
            style={[
              styles.text,
              {
                fontSize: R.fontsize.fontSizeContent,
                fontWeight: 600,
                fontFamily: R.fonts.fontMedium,
              },
            ]}>
            Học kỳ 2, Năm 2025
          </Text>
        </TouchableOpacity>
      </View>
    );
  };

  const renderButtonRegister = () => {
    return (
      <TouchableOpacity
        style={styles.btnRegister}
        onPress={() => navigation.navigate(SCREENNAME.REGISTERMAKEUP)}>
        <Text style={[styles.text, {color: R.colors.white}]}>
          Đăng kí báo bù
        </Text>
      </TouchableOpacity>
    );
  };

  const renderListEmpty = () => {
    return (
      <View style={styles.containerEmpty}>
        <View>
          <Image
            source={R.images.icNoData}
            style={{width: 50, height: 50}}
            resizeMode="contain"
          />
        </View>

        <Text style={[styles.text, {color: R.colors.red}]}>
          Không có dữ liệu
        </Text>
      </View>
    );
  };

  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderHeaderBody()}
        <View style={styles.containerList}>
          {dataList.length > 0 ? renderListClass() : renderListEmpty()}
        </View>

        {renderButtonRegister()}
      </View>
    );
  };
  return (
    <View style={styles.container}>
      <Header title={'Báo bù lịch dạy'} isBack />
      {renderBody()}
    </View>
  );
};

export default CompensateView;
